with Ada.Text_Io,Ada.Integer_Text_Io;
use Ada.Text_Io;
package body Irudiak is


   --   procedure Sortu_Irudia (
   --         Irudia     :    out Irudi;
   --         Zabalera,
   --         Altuera,
   --         Kolore_Kop : in     Integer;
   --         Pixel      : in     Matrize_Irudi ) is
   --   begin
   --      Irudia.Zabalera:=Zabalera;
   --      Irudia.Altuera:=Altuera;
   --      Irudia.Kolore_Kop:=Kolore_Kop;
   --      Irudia.Pixelak:=Pixel;
   --   end Sortu_Irudia;
   --

   procedure Kargatu_Irudia (
                             Fitx_Izena :        String;
                             Irudia     :    out Irudi   ) is
      F         : Ada.Text_Io.File_Type;
      N_Magikoa : String (1 .. 2);
      C         : Character;

   begin

      -- Grisetako argazki bat kargatu
      Ada.Text_Io.Open(F, Ada.Text_Io.In_File, Fitx_Izena);

      Ada.Text_Io.Get(F, N_Magikoa);
      Ada.Text_Io.Skip_Line(F);
      Ada.Text_Io.Get(F,C);
      if C='#' then
         Ada.Text_Io.Skip_Line(F);   -- Iruzkineko lerroa pasa
      end if;
      Ada.Integer_Text_Io.Get(F, Irudia.Zabalera);
      Ada.Integer_Text_Io.Get(F, Irudia.Altuera);
      Ada.Integer_Text_Io.Get(F, Irudia.Kolore_Kop);

      Ada.Text_Io.Put("Irudi hau: ");
      Ada.Text_Io.Put(Fitx_Izena);
      Ada.Text_Io.Put("     Mota honetakoa da: ");
      Ada.Text_Io.Put(N_Magikoa);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put("eta bere tamaina (zabalera x altuera)hau da: ");
      Ada.Integer_Text_Io.Put(Irudia.Zabalera, 3);
      Ada.Text_Io.Put(" x");
      Ada.Integer_Text_Io.Put(Irudia.Altuera, 4);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put("eta honenbeste gris maila bereizten ditu: ");
      Ada.Integer_Text_Io.Put(Irudia.Kolore_Kop, 3);
      Ada.Text_Io.Put_Line(" kolore(gris).");

      Ada.Text_Io. Put("Irudia Kargatzen");

      -- Pixelen matrizea irakurtzen
      for I in 1..Irudia.Altuera loop
         Ada.Text_Io.Put('.'); --Ada.Integer_Text_Io.put(I, 4);
         for J in 1..Irudia.Zabalera loop
            --Ada.Integer_Text_Io.put(j, 8); new_line;
            Ada.Integer_Text_Io.Get(F, Irudia.Pixelak(I, J));
         end loop;
      end loop;
      Ada.Text_Io.New_Line;

      if Ada.Text_Io.End_Of_File(F) then
         Ada.Text_Io.Put_Line("Osorik irakurri da fitxategia.");
      elsif Ada.Text_Io.End_Of_Line(F) then
         Ada.Text_Io.Put_Line
           ("Irakurri da fitxategia, baina ez da bukatu fitxategia (lerro-bukaera).");
      else
         Ada.Text_Io.Put
           ("Irakurri da fitxategia, baina ez da bukatu fitxategia (karaktereren bat).");
      end if;
      Ada.Text_Io.New_Line;

      Ada.Text_Io.Close(F);
   end Kargatu_Irudia;

   procedure Irudia_Fitxategira (
                                 Fitx_Izena : String;
                                 Irudia     : Irudi   ) is
      F : Ada.Text_Io.File_Type;
   begin
      -- Sortu pgm fitxategia argazkiarekin
      Ada.Text_Io.Put("Sortu pgm fitxategi hau irudiarekin: ");
      Ada.Text_Io.Put_Line(Fitx_Izena);
      Ada.Text_Io.Create(F, Ada.Text_Io.Out_File, Fitx_Izena);
      Ada.Text_Io.Put_Line(F, "P2");
      Ada.Text_Io.Put(F, "# irudi berria gure programak sortua ");
      Ada.Text_Io.Put_Line(F, Fitx_Izena);
      Ada.Integer_Text_Io.Put(F, Irudia.Zabalera,4);
      Ada.Integer_Text_Io.Put(F, Irudia.Altuera , 4);
      Ada.Text_Io.New_Line(F);
      Ada.Integer_Text_Io.Put(F, Irudia.Kolore_Kop);
      Ada.Text_Io.New_Line(F);
      for I in 1..Irudia.Altuera loop
         Ada.Text_Io.Put('.');
         for J in 1..Irudia.Zabalera loop
            Ada.Integer_Text_Io.Put(F, Irudia.Pixelak(I,J), 4);
         end loop;
         Ada.Text_Io.New_Line(F);
      end loop;
      Ada.Text_Io.Close(F);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put_Line("Sortu da fitxategia.");
      Ada.Text_Io.New_Line;
      Ada.Text_Io.New_Line;
   end Irudia_Fitxategira;



   procedure Borratu_Irudia (
                             Fitx_Izena : String ) is
      F : Ada.Text_Io.File_Type;
   begin
      Ada.Text_Io.Open(F,Ada.Text_Io.In_File,Fitx_Izena);
      Ada.Text_Io.Delete(F);
      Ada.Text_Io.Close(F);
   end Borratu_Irudia;



   function Zabalera (
                      Irudia : in     Irudi )
                     return Integer is
   begin
      return Irudia.Zabalera;
   end Zabalera;

   function Altuera (
                     Irudia : in     Irudi )
                    return Integer is
   begin
      return Irudia.Altuera;
   end Altuera;

   function Kolore_Kop (
                        Irudia : in     Irudi )
                       return Integer is
   begin
      return Irudia.Kolore_Kop;
   end Kolore_Kop;

   function Pixelak (
                     Irudia   : in     Irudi;
                     lerroa,
                     zutabea: in     Integer )
                    return Integer is
   begin
      return Irudia.Pixelak(Lerroa,Zutabea);
   end pixelak;

   procedure Pixel_Aldatu (
                           Irudia  : in out Irudi;
                           Lerroa,
                           Zutabea : in     Integer;
                           Balioa  : in     Integer  ) is
   begin
      Irudia.Pixelak(Lerroa, Zutabea) := Balioa;
   end Pixel_Aldatu;

   --        procedure Negatibatu (
   --              Irudia : in     Irudi;
   --              Berria :    out Irudi  ) is
   --        begin
   --          --OSATZEKO


   --        end Negatibatu;

   --        function Batezbestekoa (
   --              Irudia1 : in     Irudi )
   --          return Float is
   --           Batura : Integer := 0;
   --        begin
   --           --OSATZEKO




   --        end Batezbestekoa;


   --        procedure Zuri_Beltz_Hutsera (
   --              Irudia : in     Irudi;
   --              Berria :    out Irudi  ) is
   --           P : Float;
   --        begin
   --          --OSATZEKO





   --        end Zuri_Beltz_Hutsera;


   --        procedure Iragazi_Irudia (
   --              Irudia1,
   --              Irudia2 : in     Irudi;
   --              Berria  :    out Irudi  ) is
   --           --Aurre:Bigarren irudia zuri beltz hutsa izan behar du.
   --        begin
   --           --OSATZEKO





   --        end Iragazi_Irudia;


   procedure Errotatu (
                       Irudia :        Irudi;
                       Berria :    out Irudi;
                       Pos    :        Boolean ) is
      -- Post: Pos:True ->  Berria Irudia bezalakoa da, baina eskuinera biratuta
      --       Pos:False->  Berria Irudia bezalakoa da, baina ezkerrera biratuta
   begin
      Berria.Zabalera:= Irudia.Altuera;
      Berria.Altuera:= Irudia.Zabalera;
      Berria.Kolore_Kop:= Irudia.Kolore_Kop;
      for I in 1..Berria.Altuera   loop
         for J in 1..Berria.Zabalera  loop
            if Pos then
               Berria.Pixelak(I,J):= Irudia.Pixelak(Berria.Zabalera-J+1, I);
            else
               Berria.Pixelak(I,J):= Irudia.Pixelak(J, Berria.Altuera-I+1);
            end if;
         end loop;
      end loop;
   end Errotatu;


   --        procedure Aldatu_Kontrastea (
   --              Irudia : in out Irudi;
   --              N      : in     Integer ) is
   --           Batezbesteko : Float;
   --        begin
   --           --OSATZEKO






   --        end Aldatu_Kontrastea;


   --        procedure Fusionatu (
   --              Irudia1,
   --              Irudia2 : in     Irudi;
   --              Berria  :    out Irudi  ) is
   --        begin
   --          --OSATZEKO




   --        end Fusionatu;

   function Berdinak(Irudi1,Irudi2:Irudi) return Boolean is
   begin
      return Irudi1=Irudi2;
   end berdinak;

   procedure Txertatu_Koadroa
     (Irudia : in out Irudi;
      Irudi1 : in     Irudi;
      X,Y    : in     Integer ) is
   begin
      for I in 1..Irudi1.Zabalera loop
         --Put('.');  Put(I, 4);
         for J in 1..Irudi1.Altuera loop
            --put(Irudia.Pixelak(I, J), 5); new_line; skip_line;
            Irudia.Pixelak(X+I, Y+J):= Irudi1.Pixelak(I, J);
         end loop;
      end loop;
   end Txertatu_Koadroa;



   procedure Berdimentsionatu (
                               Irudia    : in      Irudi;
                               Zabalera,
                               Altuera : in        Integer;
                               Berria    :     out Irudi  ) is
      I_Zaharrean, J_Zaharrean : Integer;
      Zabalera1, Altuera1 : Integer;
   begin
      if Zabalera <1                 then Zabalera1 := 1;
      elsif Zabalera > Max_Zabalera  then Zabalera1 := Max_Zabalera;
      else                                Zabalera1 := Zabalera;
      end if;
      if Altuera <1                  then Altuera1 := 1;
      elsif Altuera > Max_Altuera    then Altuera1 := Max_Altuera;
      else                                Altuera1 := Altuera;
      end if;

      Berria.Zabalera := Zabalera1;
      Berria.Altuera  := Altuera1;
      --      Put(Berria.Zabalera);Put (Berria.Altuera); New_Line;
      Berria.Kolore_Kop := Irudia.Kolore_Kop;

      for I in 1..Berria.Altuera loop
         I_Zaharrean := Integer (Float(Irudia.Altuera * I)/Float(Altuera1));
         if I_Zaharrean=0               then I_Zaharrean:=1; end if;
         if I_Zaharrean>Irudia.Altuera then I_Zaharrean:=Irudia.Altuera; end if;
         for J in 1..Berria.Zabalera loop
            --put(Irudia.Pixelak(I, J), 5); new_line; skip_line;
            J_Zaharrean := Integer( (Float(Irudia.Zabalera)*Float(J))/Float(Zabalera1));
            if J_Zaharrean=0              then J_Zaharrean:=1; end if;
            if J_Zaharrean>Irudia.Zabalera then J_Zaharrean:=Irudia.Zabalera; end if;
            --Put(I,4);put(I_zaharrean,4); put(j,4);  Put(J_zaharrean, 4);New_line;
            Berria.Pixelak(I, J):= Irudia.Pixelak(I_Zaharrean, J_Zaharrean);
         end loop;
      end loop;

   end Berdimentsionatu;

   procedure Irudia_Zuritan_Sortu( Ir: out Irudi) is
      -- Post: dimentsio handienetako irudi bat sortzen du
      --      pixel guztietan 250 kolorea duena
   begin
      Ir :=
        (Max_Zabalera,
         Max_Altuera,
         Max_Kolore,
         (1 .. Max_Zabalera=> (1 .. Max_Altuera=>250)));

   end Irudia_Zuritan_Sortu;


end Irudiak;

