with Ada.Integer_Text_IO, Ada.Float_Text_IO;
package body Langile_Listak is
   -------------------------------------------
   -- Hitz motari buruzko eragiketak
   -------------------------------------------
   procedure Irakurri_Hitza
     (F: Ada.Text_IO.File_Type; P: out String; N: out Natural) is
      Kar : Character;

   begin
      N:=0;
      Ada.Text_IO.Get(F, Kar);
      while Kar = ' ' and not Ada.Text_Io.End_Of_Line(F) loop
         Ada.Text_IO.Get(F, Kar);
      end loop;

      while kar /= ' ' and not Ada.Text_Io.End_Of_Line(F) loop
         N := N + 1;
         P(N) := Kar;
         Ada.Text_IO.Get(F, Kar);
      end loop;
   end Irakurri_Hitza;


   procedure Idatzi_Hitza
     (F: Ada.Text_IO.File_Type; H : in Hitz) is

   begin
      for I in 1 .. H.Zenbat loop
         Ada.Text_IO.Put(File => F,
                         Item => H.Info(I));
      end loop;

   end Idatzi_Hitza;

   procedure Idatzi_Hitza(H : in Hitz) is
   begin
      for I in 1 .. H.Zenbat loop
         Ada.Text_IO.Put( H.Info(I));
      end loop;

   end Idatzi_Hitza;

   procedure Sortu_Hitza(H : out Hitz; S : in String; Z : in Integer) is
   begin
      H.Info:= S;
      H.Zenbat:= Z;
   end Sortu_Hitza;

   function Bi_Hitz_Berdinak (H1, H2  :  Hitz) return Boolean is
   begin
      return
        H1.Zenbat =H2.Zenbat
        and
        H1.Info(1..H1.Zenbat) = H2.Info(1..H1.Zenbat);
   end Bi_Hitz_Berdinak;

   -------------------------------------------
   -- Langile motari buruzko eragiketak
   -------------------------------------------
   procedure Irakurri_Langilea (F :        Ada.Text_IO.File_Type;
                                L :    out Langile ) is
      S : String (1 ..20);
      Kop : Integer;
      Zenb : Integer;
   begin
      Ada.Integer_Text_IO.Get(F, L.Kodea);
      Irakurri_Hitza (F => F,
                      P => S,
                      N => Kop);
      L.Izena.Info(1.. Kop):=S(1..Kop);

      L.Izena.Zenbat:= Kop;
      Irakurri_Hitza (F => F,
                      P => S,
                      N => Kop);
      L.Abizena.Info(1..Kop):=S(1..Kop);
      L.Abizena.Zenbat:= Kop;
      for I in 1 .. 5 loop
         Ada.Integer_Text_IO.Get(File  => F,
                                 Item  => Zenb);
         L.Bidaiak(I):= Zenb;
      end loop;

      if not Ada.Text_IO.End_Of_File(F) then Ada.Text_IO.Skip_Line(F);
      end if;

   end Irakurri_Langilea;


   procedure Idatzi_Langilea (F   : Ada.Text_IO.File_Type;
                              L : in Langile) is
   begin

      Ada.Integer_Text_IO.Put (File  => F,
                               Item  => L.Kodea);
      Ada.Text_IO.Put(F, ' ');
      Idatzi_Hitza(F => F,
                   H => L.Izena);
      Ada.Text_IO.Put(F, ' ');
      Idatzi_Hitza(F => F,
                   H => L.Abizena);
      Ada.Text_IO.Put(F, ' ');
      for I in 1 .. 30-L.Izena.Zenbat-L.Abizena.Zenbat loop
         Ada.Text_IO.Put(F,' ');
      end loop;
      for I in 1 .. 5 loop
         Ada.Integer_Text_IO.Put(F, L.Bidaiak(I), 5);
         Ada.Text_IO.Put(F, ' ');
      end loop;
   end Idatzi_Langilea;

   procedure Idatzi_Langilea (L : in Langile) is
   begin

      Ada.Integer_Text_IO.Put (L.Kodea);
      Ada.Text_IO.Put(' ');
      Idatzi_Hitza( L.Izena);
      Ada.Text_IO.Put(' ');
      Idatzi_Hitza(L.Abizena);
      Ada.Text_IO.Put(' ');
      for I in 1 .. 30-L.Izena.Zenbat-L.Abizena.Zenbat loop
         Ada.Text_IO.Put(' ');
      end loop;
      for I in 1 .. 5 loop
         Ada.Integer_Text_IO.Put(L.Bidaiak(I), 5);
         Ada.Text_IO.Put(' ');
      end loop;
   end Idatzi_Langilea;

   function KMen_Batezbestekoa (L : Langile )
                               return Float is
      -- pos: L langileak egindako kilometroen batezbestekoa.
   begin
      --OSATZEKO!!
      return 0.0;

   end KMen_Batezbestekoa;

   procedure KMen_Batezbestekoa_Jarri (L : in out Langile) is
      -- Post: L.Batezbestekoa = azken bost hilabeteetan langileak
      --        egin dituen Km-en batezbestekoa.
      Batura : Integer;
   begin
      --OSATZEKO!!
      null;
      
      
      
      
   end KMen_Batezbestekoa_Jarri;



   function Langilearen_KMKop_Max (L : Langile )
                                  return Integer is
      -- pos: L langileak egindako kilometroen kopuru maximoaren hilabetea
      Bk_Taula:Bidai_Taula;
      MaxKM: Integer:=Integer'first;
   begin
      --OSATZEKO!!
      return 1;
      
      
   end Langilearen_KMKop_Max;


   -------------------------------------------
   -- Langile_Listaren inguruko eragiketak
   -------------------------------------------
   procedure Fitxategitik_Irakurri (FIzena :        String;
                                    LL        :    out Langile_Lista ) is
      -- pre: Langile bakoitzako bere izena,abizena eta 5 zenbaki azkeneko
      --     hilabetetan egindako KMen kopuruak adierazten dutenak
      -- pos: LL Langilearen lista bere fitxategitik
      --      irakurritako informazioarekin.
      F_In : Ada.Text_IO.File_Type;
      Langilea : Langile;
   begin
      Ada.Text_IO.Open(File => F_in,
                       Mode => Ada.Text_IO.In_File,
                       Name => FIzena);
      LL.Zenbat := 0;
      while not Ada.Text_IO.End_Of_File(F_In) loop
         Irakurri_Langilea(F => F_In,
                           L => Langilea);
         LL.Zenbat := LL.Zenbat + 1;
         LL.Info(LL.Zenbat):= Langilea;
      end loop;
      Ada.Text_IO.Close(F_in);
   end Fitxategitik_Irakurri;


   function Zenbat (LL : Langile_Lista )
                   return Natural is
      -- pos: Kont (Osoko), Kont = Langile kopurua
   begin
      return LL.Zenbat;
   end Zenbat;


   function Langilea (LL : Langile_Lista;
                      I : Natural      )
                     return Langile is
      -- pos: L (Langile), L = LL listan Igarren posizioan dagoen langilea
   begin
      return ll.Info(I);
   end Langilea;

   procedure KMen_Batezbestekoak_Jarri (LL : in out Langile_Lista) is
   -- Post: LL listako eosagai guztietan:
   --          Batezbestekoa = azken bost hilabeteetan langileak
   --            egin dituen Km-en batezbestekoa.
   begin
     --OSATZEKO!!      
      null;
   end KMen_Batezbestekoak_Jarri;


   function Batezbesteko_KM_Guztira (LL : Langile_Lista )
                                    return Float is
      -- pos: Batez (Float), Batez = LL listaren langile guztien
      --      KM kopuruaren batezbestekoa
      Batezb : Float;
   begin
      --OSATZEKO!!
      
      return 0.0;
   end Batezbesteko_KM_Guztira;

   procedure  Bilatu_Kodea  (LL      : in     Langile_Lista;
                             K       : in     Natural;
                             Aurkitua:    out Boolean;
                             Pos     :    out Integer) is
      -- Post: Aurkitua=True eta LL.Info(Pos).Kodea=K aurkitu bada
      --       Aurkitua=False eta Pos=0 aurlkitu ez bada.
      I : Integer;
   begin
      --OSATZEKO!!
      Aurkitua := False;
      Pos := I1;
   end Bilatu_Kodea ;

   procedure  Bilatu_Abizena  (LL      : in     Langile_Lista;
                               Ab      : in     Hitz;
                               Aurkitua:    out Boolean;
                               Pos     :    out Integer) is
      -- Post: Aurkitua=True eta  Ab = LL.Info(Pos).Abizena aurkitu bada
      --       Aurkitua=False eta Pos=0 aurlkitu ez bada.
      I : Integer;
   begin
      --OSATZEKO!!
       Aurkitua := False;
      Pos := I1;

   end Bilatu_Abizena ;

   procedure Ordenatu_Kodez  (L: in out Langile_lista) is
      -- Aurrebaldintza:
      -- Postbaldintza:  L listako elementuak
      --                ordenatuta daude kode txikienetik handienera
      Pos : Integer;
   begin
      --OSATZEKO!!
      null;
   end Ordenatu_Kodez ;

   procedure Ordenatu_Batezbestekoaz  (L: in out Langile_lista) is
      -- Aurrebaldintza:
      -- Postbaldintza:  L listako elementuak
      --                ordenatuta daude kode txikienetik handienera
      Pos : Integer;
   begin
      --OSATZEKO!!
      null;

   end Ordenatu_Batezbestekoaz ;

   procedure Balioak_Trukatu (X1, X2 : in out Langile) is
      Lag : Langile;
   begin
      Lag := X1;
      X1 := X2;
      X2 := Lag;
   end Balioak_Trukatu;

   procedure Bilatu_Kode_Minimoaren_Posizioa
     (B: in Langile_Taula;
      I1, I2: in Integer;
      Minimoaren_Posizioa: out Integer) is
      -- Aurrebaldintza:
      --   I1 eta I2 B bektorearen indize posibleak dira.
      -- Postbaldintza:  B(I1) ... B(I2) osagaien artekoen kode txikiena
      --                  B(Minimoaren_Posizioa)-rena  da.
   Minimoa: Integer;
   begin
     --OSATZEKO!!
      Minimoaren_Posizioa := I1;

   end Bilatu_Kode_Minimoaren_Posizioa ;


   procedure Bilatu_Batezbesteko_Minimoaren_Posizioa
     (B: in Langile_Taula;
      I1, I2: in Integer;
      Minimoaren_Posizioa: out Integer) is
      -- Aurrebaldintza:
      --   I1 eta I2 B bektorearen indize posibleak dira.
      -- Postbaldintza:  B(I1) ... B(I2) osagaien artekoen batezbesteko txikiena
      --                  B(Minimoaren_Posizioa)-rena  da.
   Minimoa: Float;
   begin
      --OSATZEKO!!
      Minimoaren_Posizioa := I1;

   end Bilatu_Batezbesteko_Minimoaren_Posizioa ;

   procedure Fitxategira_Pasa (F_Out_Izena:  in  String;
                               LL: in Langile_Lista) is
      F_Out : Ada.Text_IO.File_Type;
   begin
      Ada.Text_IO.Create(File => F_Out,
                         Mode => Ada.Text_IO.Out_File,
                         Name => F_Out_Izena);
      for I in 1 .. LL.Zenbat loop
         Idatzi_Langilea
           (F => F_Out,
            L => ll.Info(I));
         Ada.Text_IO.New_Line(F_Out);
      end loop;
      Ada.Text_IO.Close(F_Out);
   end Fitxategira_Pasa;


end Langile_Listak;


