with Ada.Text_Io;
package Langile_Listak is
   type Langile_Lista is private;
   type Langile is private;
   type Hitz is private;
   type Langile_Taula is private;


   procedure Sortu_Hitza(H : out Hitz; S : in String; Z : in Integer);
   function Bi_Hitz_Berdinak (H1, H2  :  Hitz) return Boolean ;
   ---------------------------------------
   -- LANGILE MOTARI BURUZKO ERAGIKETAK
   ---------------------------------------

   procedure Irakurri_Langilea (F :        Ada.Text_IO.File_Type;
                                L :    out Langile );

   procedure Idatzi_Langilea (F   : Ada.Text_IO.File_Type;
                              L : in Langile);
   procedure Idatzi_Langilea (L : in Langile);

   function KMen_Batezbestekoa (L : Langile ) return Float ;
      -- pos: L langileak egindako kilometroen batezbestekoa.

   procedure KMen_Batezbestekoa_Jarri (L : in out Langile) ;
   -- Post: L.Batezbestekoa = azken bost hilabeteetan langileak
   --        egin dituen Km-en batezbestekoa.
   function Langilearen_KMKop_Max (L : Langile )
                                  return Integer;
   -- pos: L langileak egindako kilometroen kopuru maximoaren hilabetea


   ---------------------------------------
   -- LANGILE_LISTAREN INGURUKO ERAGIKETAK
   ---------------------------------------

   procedure Fitxategitik_Irakurri (FIzena :        String;
                                    LL     :    out Langile_Lista );
   -- pre: Langile bakoitzako bere izena,abizena eta 5 zenbaki azkeneko
   --     hilabetetan egindako KMen kopuruak adierazten dutenak
   -- pos: LL Langilearen lista bere fitxategitik
   --      irakurritako informazioarekin.

   function Zenbat (LL : Langile_Lista )
                   return Natural;
   -- pos: Kont (Osoko), Kont = Langile kopurua

   function Langilea (LL : Langile_Lista;
                      I  : Natural)
                     return Langile;
   -- pos: L (Langile), L = LL listan Igarren posizioan dagoen langilea

   procedure KMen_Batezbestekoak_Jarri (LL : in out Langile_Lista) ;
   -- Post: LL listako eosagai guztietan:
   --          Batezbestekoa = azken bost hilabeteetan langileak
   --            egin dituen Km-en batezbestekoa.


   function Batezbesteko_KM_Guztira (LL : Langile_Lista )
                          return Float;
   -- pos: Batez (Float), Batez = LL listaren langile guztien
   --      KM kopuruaren batezbestekoa

   procedure  Bilatu_Kodea  (LL      : in     Langile_Lista;
                             K       : in     Natural;
                             Aurkitua:    out Boolean;
                             Pos     :    out Integer) ;
      -- Post: Aurkitua=True eta LL.Info(Pos).Kodea=K aurkitu bada
      --       Aurkitua=False eta Pos=0 aurlkitu ez bada.

   procedure  Bilatu_Abizena  (LL      : in     Langile_Lista;
                               Ab      : in     Hitz;
                               Aurkitua:    out Boolean;
                               Pos     :    out Integer) ;
      -- Post: Aurkitua=True eta  Ab = LL.Info(Pos).Abizena aurkitu bada
      --       Aurkitua=False eta Pos=0 aurlkitu ez bada.

   procedure Ordenatu_Kodez  (L: in out Langile_lista) ;
      -- Aurrebaldintza:
      -- Postbaldintza:  L listako elementuak
      --                ordenatuta daude kode txikienetik handienera

   procedure Ordenatu_Batezbestekoaz  (L: in out Langile_lista);

   procedure Balioak_Trukatu (X1, X2 : in out Langile) ;

   procedure Bilatu_Kode_Minimoaren_Posizioa
                (B: in Langile_Taula;
                 I1, I2: in Integer;
                 Minimoaren_Posizioa: out Integer) ;
   -- Aurrebaldintza:
   --   I1 eta I2 B bektorearen indize posibleak dira.
   -- Postbaldintza:  B(I1) ... B(I2) osagaien artekoen kode txikiena
   --                  B(Minimoaren_Posizioa)-rena  da.

   procedure Bilatu_Batezbesteko_Minimoaren_Posizioa
     (B: in Langile_Taula;
      I1, I2: in Integer;
      Minimoaren_Posizioa: out Integer) ;
      -- Aurrebaldintza:
      --   I1 eta I2 B bektorearen indize posibleak dira.
      -- Postbaldintza:  B(I1) ... B(I2) osagaien artekoen batezbesteko txikiena
      --                  B(Minimoaren_Posizioa)-rena  da.


   procedure Fitxategira_Pasa (F_Out_Izena : in String;
                               LL: in Langile_Lista);


private
subtype Bost_Hilabete is Integer range 1..5;

   type Bidai_Taula is array (Bost_Hilabete) of Integer;

   type Hitz is record
         Info : String (1 .. 15);
         Zenbat : Natural;
      end record;

   type Langile is record
         Kodea   : Natural;
         Izena,
         Abizena : Hitz;
         Bidaiak : Bidai_Taula;
         Batezbestekoa: Float;
   end record;

   Max_Langile : Natural := 100;
   subtype Indize1_Max_Langile is Integer range 1.. Max_Langile;
   subtype Indize0_Max_Langile is Integer range 0.. Max_Langile;

   type Langile_Taula is array (Indize1_Max_Langile) of Langile;

   type Langile_Lista is record
         Info  : Langile_Taula;
         Zenbat: Indize0_Max_Langile;
   end record;


end Langile_Listak;
