-- Author: Omar
with Ada.Integer_Text_IO;
with Ada.Text_IO;
with Osokoak;

package Mezuak is

    type Mezu is private;
    type Mezu_Kodetu is private;
    
    function Mezu_Berria return Mezu;
        --Aurre:
        --Post: Mezu hutsa bueltatzen du
    
    procedure Idatzi_Mezua(
            Esaldia : in String;
            M : in out Mezu);
        --Aurre: Esaldia gehienez 80 karaktere
        --Post: M Mezuan Esaldia dago, eta honen luzera
    
    function Irakurri_Mezua(M : in Mezu) return String;
        --Aurre: M mezusa ez hutsa
        --Post: M mezuaren esaldia bueltatzen du
    
    
    function Mezu_Kodetu_Berria return Mezu_Kodetu;
        --Aurre:
        --Post: Mezu_Kodetu hutsa bueltatzen du 
    
    procedure Idatzi_Mezu_Kodetua(MK : in out Mezu_Kodetu);
        --Aurre: 
        --Post: MK Mezu_kodetuan osoko_taula eta honen luzera dago       
    
    procedure Irakurri_Mezu_Kodetua(MK : in Mezu_Kodetu);
        --Aurre: MK mezu_kodetu ez hutsa
        --Post: MK mezuaren osoko_taula bueltatzen du

    function Zenbakitik_Letrara(Zen: in Natural) return Character;
        --Aurre: Zen zenbakiari ASCII karaktere bat dagokio
        --Post: Zen zenbakiari dagokion  ASCII karakterea bueltatzen du 
    
    function Letratik_Zenbakira(Kar: in Character) return Integer;
        --Aurre: Kar ASCII karaktereari zenbaki bati dagokio 
        --Post: Kar ASCII karaktereari dagokion zenbakia bueltatzen du     

    procedure Kodetu(
            M : in Mezu;
            n : in Integer;
            r : in Integer;
            MK : out Mezu_Kodetu);
        --Aurre: M = <m1, m2, ..., mn> Mezua kodetu gabe dago, n eta r kodetzeko giltza publikoak dira
        --Post: MK = <mk1, mk2, ..., mkn> da, mki = mi**r mod n izanik
    
    procedure Deskodetu_Giltzekin(
            MK : in Mezu_Kodetu;
            n : in Integer;
            s : in Integer;
            M : out Mezu);
        --Aurre: MK = <mk1, mk2, ..., mkn> Mezua kodetuta dago, n eta s deskodetzeko giltzak izanik
        --Post: M = <m1, m2, ..., mn> mezua deskodetuta da, mi = mki**s mod n izanik
           
    procedure Deskodetu(MK : in Mezu_Kodetu);
    --Aurre: MK mezua kodetuta dago, kodetzeko giltzak 17<p<43 eta 17<q<43 izanik.
    --Post: Sarrerako mezuaren deskodeketa posible guztiak idazten ditu.   
    
private
    Max : constant Positive := 80;
    type Osoko_Taula is array (1..Max) of Integer;
    
    type Mezu is 
        record
            Mezua  : String (1..Max);
            Luzera : Natural;
        end record;
    
    type Mezu_Kodetu is 
        record
            Mezua  : Osoko_Taula;
            Luzera : Natural;
        end record;
    
end Mezuak;
