-- Author: Omar

package body Mezuak is
    
    function Mezu_Berria return Mezu is
        --Aurre:
        --Post: Mezu hutsa bueltatzen du
        
       M : Mezu; 
    begin
        M.Luzera := 0;
        return M;
    end Mezu_Berria;
    
    -------------------------------------------------------------    
    
    procedure Idatzi_Mezua(
            Esaldia : in String;
            M : in out Mezu) is
        --Aurre: Esaldia gehienez 80 karaktere
        --Post: M Mezuan Esaldia dago, eta honen luzera
       
        I : Integer := 1;         
    begin
        M.Mezua := Esaldia;
        while M.Mezua(I) /= '.' loop
            I := I+1;
        end loop;
        M.Luzera := I-1;
    end Idatzi_Mezua;
    
    -------------------------------------------------------------
    
    function Irakurri_Mezua(M : in Mezu) return String is
        --Aurre: M mezusa ez hutsa
        --Post: M mezuaren esaldia bueltatzen du
        
        Esaldia : String(1..(M.Luzera+1)); 
    begin
        for I in 1..M.Luzera loop
            Esaldia(I) := M.Mezua(I);
        end loop;
        Esaldia(M.Luzera +1) := '.';
        return Esaldia;    
    end Irakurri_Mezua;

    -------------------------------------------------------------
    
    function Mezu_Kodetu_Berria return Mezu_Kodetu is
        --Aurre:
        --Post: Mezu_Kodetu hutsa bueltatzen du
        
       MK : Mezu_Kodetu; 
    begin
        MK.Luzera := 0;
        return MK;
    end Mezu_Kodetu_Berria;
    
    -------------------------------------------------------------    
    
    procedure Idatzi_Mezu_Kodetua(MK : in out Mezu_Kodetu) is
        --Aurre:
        --Post: MK Mezu_kodetuan osoko_taula eta honen luzera dago
       
        I, Zen : Integer;         
    begin
        I := 1;
        Ada.Integer_Text_IO.Get(Zen);
        while Zen /= 0 loop
            MK.Mezua(I) := Zen;
            I := I+1;
            Ada.Integer_Text_IO.Get(Zen);
        end loop;
        MK.Mezua(I) := 0;
        MK.Luzera := I-1;
    end Idatzi_Mezu_Kodetua;
    
    -------------------------------------------------------------
    
    procedure Irakurri_Mezu_Kodetua(MK : in Mezu_Kodetu) is
        --Aurre: MK mezu_kodetu ez hutsa
        --Post: MK mezuaren osoko_taula bueltatzen du
         
    begin
        for I in 1..(MK.Luzera +1) loop
            Ada.Integer_Text_IO.Put(MK.Mezua(I));
        end loop;    
    end Irakurri_Mezu_Kodetua;

    -------------------------------------------------------------
    
    function Zenbakitik_Letrara(Zen: in Natural) return Character is
        --Aurre: Zen zenbakiari ASCII karaktere bat dagokio
        --Post: Zen zenbakiari dagokion ASCII karaktera bueltatzen du 
        
       A : Integer;
    begin
        A := Zen mod 255; --Deskodetu_proba-n constraint_error ez emateko
        return Character'Val(A);
    end Zenbakitik_Letrara;

    -------------------------------------------------------------
    
    function Letratik_Zenbakira(Kar: in Character) return Integer is
        --Aurre: Kar ASCII karaktereari zenbaki bati dagokio 
        --Post: Kar ASCII karaktereari dagokion zenbakia bueltatzen du 

    begin
        return Character'Pos(Kar);
    end Letratik_Zenbakira;

    -------------------------------------------------------------
    
    procedure Kodetu(
            M : in Mezu;
            n : in Integer;
            r : in Integer;
            MK : out Mezu_Kodetu) is
        --Aurre: M = <m1, m2, ..., mn, '.'> Mezua kodetu gabe dago, n eta r kodetzeko giltza publikoak izanik
        --Post: MK = <mk1, mk2, ..., mkn, 0> mezua kodetuta da, mki = mi**r mod n izanik

        
        procedure Kodetu1(
                M : in Integer;
                n : in Integer;
                r : in Integer;
                MK : out Integer) is
            --Aurre: M zenbakia kodetu gabe dago
            --Post: MK = M**r mod n da
            
           b, A, Biderkadura : Integer; 
        begin
            Biderkadura := 1;
            b := r;
            A := M;
            while b >= 1 loop
                if b mod 2 = 1 then
                    Biderkadura := (A mod n) * Biderkadura;
                    Biderkadura := Biderkadura mod n;
                end if;
                b := b/2;
                A := A**2 mod n;
            end loop;
            MK:= Biderkadura mod n;   
        end Kodetu1;
                        

        Lag : Integer;
    begin
        MK.Luzera := M.Luzera;
        for I in 1..M.Luzera loop
            Lag := Letratik_Zenbakira(M.Mezua(I));
            Kodetu1(Lag, n, r, Lag);         
            MK.Mezua(I) := Lag;
        end loop;
        MK.Mezua(MK.Luzera +1) := 0;
    end Kodetu;
    
    -------------------------------------------------------------

    procedure Deskodetu_Giltzekin(
            MK : in Mezu_Kodetu;
            n : in Integer;
            s : in Integer;
            M : out Mezu) is
        --Aurre: MK = <mk1, mk2, ..., mkn, 0> Mezua kodetuta dago, n eta s deskodetzeko giltzak izanik
        --Post: M = <m1, m2, ..., mn, '.'> mezua deskodetuta da, mi = mki**s mod n izanik
        
        
        procedure Deskodetu_Giltzekin1(
                MK : in Integer;
                n : in Integer;
                s : in Integer;
                M : out Integer) is
            --Aurre: MK zenbakia kodetuta dago
            --Post: M = MK**s mod n da
            
           b, R, Biderkadura : Integer; 
        begin
            Biderkadura := 1;
            b := s;
            R := MK;
            while b >= 1 loop
                if b mod 2 = 1 then
                    Biderkadura := (R mod n) * Biderkadura;
                    Biderkadura := Biderkadura mod n;
                end if;
                b := b/2;
                R := R**2 mod n;
            end loop;
            M := Biderkadura;    
        end Deskodetu_Giltzekin1;
                            
       
       Lag : Integer;                 
    begin
        M.Luzera := MK.Luzera;
        for I in 1..MK.Luzera loop           
            Lag := MK.Mezua(I);
            Deskodetu_Giltzekin1(Lag, n, s, Lag);
            M.Mezua(I) := Zenbakitik_Letrara(Lag);
        end loop;
        M.Mezua(M.Luzera +1) := '.';
    end Deskodetu_Giltzekin;
    
    -------------------------------------------------------------
    
    procedure Deskodetu(MK : in Mezu_Kodetu) is
        --Aurre: MK mezua kodetuta dago, kodetzeko giltzak 17<p<43 eta 17<q<43 izanik.
        --Post: Sarrerako mezuaren deskodeketa posible guztiak idazten ditu.       
       
        B : Array (1..8) of Integer := (17, 19, 23, 29, 31, 37, 41, 43);
        I, J, N, R, S : Integer;
        M : Mezu;
    begin
        M.Luzera := MK.Luzera;
        I := 1;
        while I < 8 loop
            J := I + 1;
            while J <= 8 loop
                Osokoak.Giltzak_Definitu(B(I), B(J), N, R, S);
                Deskodetu_Giltzekin(MK, N, S, M);
                Ada.Text_IO.Put_Line(Irakurri_Mezua(M));
                J := J + 1;
            end loop;
            I := I + 1;
        end loop;
    end Deskodetu;

end Mezuak;
