package body Koordenatuak_R is

   function  Osagaiak (P : Koordenatuak_R.Koordenatu;
                       I : Indize)
                      return Float is
   -- Aurre:
   -- Post:
   begin
      return P(I);
   end Osagaiak;


   function X (K1: in Koordenatuak_R.Koordenatu)
              return Float is
      -- Aurre:
      -- Post:
   begin
      return K1(1);
   end X;

   function Y (K1: in Koordenatuak_R.Koordenatu)
              return Float is
      -- Aurre:
      -- Post:
   begin
      return K1(2);
   end Y;

   procedure Osagaiak_Jarri (K1: out Koordenatuak_R.Koordenatu;
                           X_Balioa, Y_Balioa: Float) is
      -- Aurre:
      -- Post:
   begin
      K1(1) := X_Balioa;
      K1(2) := Y_Balioa;
   end Osagaiak_Jarri;

   procedure Osagaia_Jarri (K1: out Koordenatuak_R.Koordenatu;
                            I: Indize;
                            Balioa: Float) is
      -- Aurre:
      -- Post:
   begin
      K1(I) := Balioa;
   end Osagaia_Jarri;

   function Batura (K1, K2: in Koordenatuak_R.Koordenatu)
                   return Koordenatuak_R.Koordenatu is
      -- Postbaldintza: emaitza K1 eta K2ren batura;
      Emaitza : Koordenatuak_R.Koordenatu;
   begin
      Emaitza(1) := K1(1) + K2(1);
      Emaitza(2) := K1(2) + K2(2);
      return Emaitza;
   end Batura;

   function Kendura (K1, K2: in Koordenatuak_R.Koordenatu)
                   return Koordenatuak_R.Koordenatu is
      -- Postbaldintza: emaitza K1 eta K2ren kendura;
      Emaitza : Koordenatuak_R.Koordenatu;
   begin
      Emaitza(1) := K1(1) - K2(1);
      Emaitza(2) := K1(2) - K2(2);
      return Emaitza;
   end Kendura;

   function Biderkadura (K : in Float;
                         K1: in Koordenatuak_R.Koordenatu)
                        return Koordenatuak_R.Koordenatu is
      -- Aurrebaldintza: K1 2x2 dimentsioko matrizea da
      -- Postbaldintza: emaitza K zenbakiaren eta K1 matrizearen
      --    arteko biderkadura da eta emaitza MxN dimentsiokoa
      --    izango da;
      Emaitza : Koordenatuak_R.Koordenatu;
   begin
      Emaitza(1) := K * K1(1);
      Emaitza(2) := K * K1(2);
      return Emaitza;
   end Biderkadura;

   procedure Jatorri_Aldaketa (P: out Koordenatuak_R.Koordenatu;
                               P_H: in Koordenatuak_R.Koordenatu;
                               X1, Y1: in float) is
      --Aurre:
      --Post: P eta P_H puntu beraren korrdinatuakdira
      --         P_H koordenatuak (0.0, 0.0) koordenatu-jatorria hartuta
      --         eta P koordenatuak jatorri-puntua (X1,Y1) izanda
   begin
      Koordenatuak_R.Osagaiak_Jarri
        (P,
         Koordenatuak_R.X(P_H)-X1,
         Koordenatuak_R.Y(P_H)-Y1);
   end Jatorri_Aldaketa;

end Koordenatuak_R;
