package Irudiak is

   type Irudi is private;
   Max_Kolore : constant Integer := 256;
   Max_Zabalera,
   Max_Altuera  : constant Integer := 112;--255;--112;--350
   Habekoa, Kuadranteak : constant Irudi;


   --   procedure Sortu_Irudia (
   --         Irudia     :    out Irudi;
   --         Zabalera,
   --         Altuera,
   --         Kolore_Kop : in     Integer --
   --       Pixelak    : in     Matrize_Irudiak.Matrize_Irudi);
   -- hau azkenean ez da beharko irudi guztiak fitxategi baten bitartez etorriko dira eta
   -- probetarako aurrean dagoen konstantea definitu dugu.
   procedure Kargatu_Irudia (
         Fitx_Izena :        String;
         Irudia     :    out Irudi   );

   procedure Irudia_Fitxategira (
         Fitx_Izena : String;
         Irudia     : Irudi   );

   procedure Borratu_Irudia (
         Fitx_Izena : String );

   function Zabalera (
         Irudia : in     Irudi )
     return Integer;

   function Altuera (
         Irudia : in     Irudi )
     return Integer;

   function Kolore_Kop (
         Irudia : in     Irudi )
     return Integer;

   function Pixelak (
         Irudia  : in     Irudi;
         Lerroa,
         Zutabea : in     Integer )
     return Integer;

   procedure Pixel_Aldatu (
         Irudia  : in out Irudi;
         Lerroa,
         Zutabea : in     Integer;
         Balioa  : in     Integer  );


   procedure Transformazioa  ( Irudia : in     Irudi;
                               Berria :    out Irudi;
                               Transf : in     String;
                               A      : in     Float ) ;

    procedure Txertatu_Koadroa
            (Irudia : in out Irudi;
             Irudi1 : in     Irudi;
             X,Y    : in     Integer ) ;



    procedure Berdimentsionatu (
            Irudia    : in      Irudi;
            Zabalera,
            Altuera : in        Integer;
            Berria    :     out Irudi  ) ;


    procedure Irudia_Zuritan_Sortu( Ir: out Irudi) ;
    -- Post: dimentsio handienetako irudi bat sortzen du
    --      pixel guztietan 250 kolorea duena

private
   Fondoko_Kolorea : constant Integer := 128;
   subtype T_Kolore is Integer range 0..Max_Kolore-1;
   type Matrize_Irudi is array (1 .. Max_Zabalera, 1 .. Max_Altuera) of T_Kolore;
   type Irudi is
      record
         Zabalera,
         Altuera,
         Kolore_Kop : Integer;
         Pixelak    : Matrize_Irudi;
      end record;

   Habekoa : constant Irudi :=
     (128, 76, 256,
      ((1 .. 76 => (1 .. 76 => 50, others => 100),
        others => (1 .. 76 => 100, others => 100))));

--     Kuadranteak21: constant Irudi :=
--       (21, 21, 256,
--        ((1 .. 10 => (1 .. 10 => 1, 11=> 150, others => 50),
--          11   => (1 => 150, others => 150),
--          others => (1 .. 10 => 200, 11=> 150, others => 250))));

   Kuadranteak: constant Irudi :=
     (101, 101, 256,
      ((1 .. 50 => (1 .. 50 => 1, 51=> 125, others => 100),
        51      => (1 => 125, others => 125),
        others  => (1 .. 50 => 150, 51=> 125, others => 250))));


end Irudiak;

