with Ada.Numerics.Generic_Elementary_Functions;
use Ada.Numerics;
with Ada.Text_Io,Ada.Integer_Text_Io;
use Ada.Text_Io;
with Matrizeak_R, Koordenatuak_R;

package body Irudiak is
   --   procedure Sortu_Irudia (
   --         Irudia     :    out Irudi;
   --         Zabalera,
   --         Altuera,
   --         Kolore_Kop : in     Integer;
   --         Pixel      : in     Matrize_Irudi ) is
   --   begin
   --      Irudia.Zabalera:=Zabalera;
   --      Irudia.Altuera:=Altuera;
   --      Irudia.Kolore_Kop:=Kolore_Kop;
   --      Irudia.Pixelak:=Pixel;
   --   end Sortu_Irudia;


  procedure Kargatu_Irudia (
                             Fitx_Izena :        String;
                             Irudia     :    out Irudi   ) is
      F         : Ada.Text_Io.File_Type;
      N_Magikoa : String (1 .. 2);
      C         : Character;
   begin
      -- Grisetako argazki bat kargatu
      Ada.Text_Io.Open(F, Ada.Text_Io.In_File, Fitx_Izena);

      Ada.Text_Io.Get(F, N_Magikoa);
      Ada.Text_Io.Skip_Line(F);
      Ada.Text_Io.Get(F,C);
      if C='#' then
         Ada.Text_Io.Skip_Line(F);   -- Iruzkineko lerroa pasa
      end if;
      Ada.Integer_Text_Io.Get(F, Irudia.Zabalera);
      Ada.Integer_Text_Io.Get(F, Irudia.Altuera);
      Ada.Integer_Text_Io.Get(F, Irudia.Kolore_Kop);

      Ada.Text_Io.Put("Irudi hau: ");
      Ada.Text_Io.Put(Fitx_Izena);
      Ada.Text_Io.Put("     Mota honetakoa da: ");
      Ada.Text_Io.Put(N_Magikoa);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put("eta bere tamaina (zabalera x altuera)hau da: ");
      Ada.Integer_Text_Io.Put(Irudia.Zabalera, 3);
      Ada.Text_Io.Put(" x");
      Ada.Integer_Text_Io.Put(Irudia.Altuera, 4);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put("eta honenbeste gris maila bereizten ditu: ");
      Ada.Integer_Text_Io.Put(Irudia.Kolore_Kop, 3);
      Ada.Text_Io.Put_Line(" kolore(gris).");

      Ada.Text_Io. Put("Irudia Kargatzen");

      -- Pixelen matrizea irakurtzen
      for I in 1..Irudia.Altuera loop
         Ada.Text_Io.Put('.'); --Ada.Integer_Text_Io.put(I, 4);
         for J in 1..Irudia.Zabalera loop
            --Ada.Integer_Text_Io.put(j, 8); new_line;
            Ada.Integer_Text_Io.Get(F, Irudia.Pixelak(I, J));
         end loop;
      end loop;
      Ada.Text_Io.New_Line;

      if Ada.Text_Io.End_Of_File(F) then
         Ada.Text_Io.Put_Line("Osorik irakurri da fitxategia.");
      elsif Ada.Text_Io.End_Of_Line(F) then
         Ada.Text_Io.Put_Line
           ("Irakurri da fitxategia, baina ez da bukatu fitxategia (lerro-bukaera).");
      else
         Ada.Text_Io.Put
           ("Irakurri da fitxategia, baina ez da bukatu fitxategia (karaktereren bat).");
      end if;
      Ada.Text_Io.New_Line;

      Ada.Text_Io.Close(F);
   end Kargatu_Irudia;

   procedure Irudia_Fitxategira (
                                 Fitx_Izena : String;
                                 Irudia     : Irudi   ) is
      F : Ada.Text_Io.File_Type;
   begin
      -- Sortu pgm fitxategia argazkiarekin
      Ada.Text_Io.Put("Sortu pgm fitxategi hau irudiarekin: ");
      Ada.Text_Io.Put_Line(Fitx_Izena);
      Ada.Text_Io.Create(F, Ada.Text_Io.Out_File, Fitx_Izena);
      Ada.Text_Io.Put_Line(F, "P2");
      Ada.Text_Io.Put(F, "# irudi berria gure programak sortua ");
      Ada.Text_Io.Put_Line(F, Fitx_Izena);
      Ada.Integer_Text_Io.Put(F, Irudia.Zabalera,4);
      Ada.Integer_Text_Io.Put(F, Irudia.Altuera , 4);
      Ada.Text_Io.New_Line(F);
      Ada.Integer_Text_Io.Put(F, Irudia.Kolore_Kop);
      Ada.Text_Io.New_Line(F);
      for I in 1..Irudia.Altuera loop
         Ada.Text_Io.Put('.');
         for J in 1..Irudia.Zabalera loop
            Ada.Integer_Text_Io.Put(F, Irudia.Pixelak(I,J), 4);
         end loop;
         Ada.Text_Io.New_Line(F);
      end loop;
      Ada.Text_Io.Close(F);
      Ada.Text_Io.New_Line;
      Ada.Text_Io.Put_Line("Sortu da fitxategia.");
      Ada.Text_Io.New_Line;
      Ada.Text_Io.New_Line;
   end Irudia_Fitxategira;

   procedure Borratu_Irudia (
                             Fitx_Izena : String ) is
      F : Ada.Text_Io.File_Type;
   begin
      Ada.Text_Io.Open(F,Ada.Text_Io.In_File,Fitx_Izena);
      Ada.Text_Io.Delete(F);
      Ada.Text_Io.Close(F);
   end Borratu_Irudia;

   function Zabalera (
                      Irudia : in     Irudi )
                     return Integer is
   begin
      return Irudia.Zabalera;
   end Zabalera;

   function Altuera (
                     Irudia : in     Irudi )
                    return Integer is
   begin
      return Irudia.Altuera;
   end Altuera;

   function Kolore_Kop (
                        Irudia : in     Irudi )
                       return Integer is
   begin
      return Irudia.Kolore_Kop;
   end Kolore_Kop;

   function Pixelak (
                     Irudia   : in     Irudi;
                     lerroa,
                     zutabea: in     Integer )
                    return Integer is
   begin
      return Irudia.Pixelak(Lerroa,Zutabea);
   end pixelak;

   procedure Pixel_Aldatu (
                           Irudia  : in out Irudi;
                           Lerroa,
                           Zutabea : in     Integer;
                           Balioa  : in     Integer  ) is
   begin
      Irudia.Pixelak(Lerroa, Zutabea) := Balioa;
   end Pixel_Aldatu;


   procedure Transformazioa  ( Irudia : in     Irudi;
                               Berria :    out Irudi;
                               Transf : in     String;
                               A      : in     Float )  is
      -- Aurre: Tranf-en balioak
      --          "b_": biraketa, "ib": islapen bertikala, "ih": islapen horizontala,
      --          "db": distortsio bertikala, "dh": distortsio horizontala,
      --          "tb": translazio  bertikala, "th": translazio horizontala
      --          "i4" Y=x zuzenarekiko islapena
      -- Post: Berria Irudia bezalakoa da,
      --       baina Transf tranformazioa A parametroarekin eginda.
      I0, J0 : Integer;
      P0, P0_H : Koordenatuak_R.Koordenatu;
      I_Erdian : constant Integer :=(Irudia.Altuera )/2 + 1;
      J_Erdian : constant Integer :=(Irudia.Zabalera)/2 + 1;
      --package MiFloat_IO is new Float_IO(float);
      package Funciones is new Generic_Elementary_Functions(float);
      use  Funciones; --MiFloat_IO,

      procedure  Bilatu_Zein_Pixel_Kopiatu_Behar_Den
        (Irudia : in     Irudi;
         I1, J1 : in     Integer;
         P0_H   :    out Koordenatuak_R.Koordenatu;
         Transf : in     String;
         A      : in     Float ) is
         --  Aurre:
         -- Post: Transf transformazioa A parametroarekin eginda,
         --       P0_H koordenatuko pixela (I1,J1) puntura joando da
         M: Matrizeak_R.Matrize;
         P, P_H : Koordenatuak_R.Koordenatu;

      begin
         Koordenatuak_R.Osagaiak_Jarri( P_H,
                                        Float(I1),
                                        Float(J1));
         Koordenatuak_R.Jatorri_aldaketa( P, P_H, Float(I_Erdian), Float(J_Erdian));

         if Transf ="b_" then
            -- M matrizeak (-A) graduko biraketa adierazten du
            Matrizeak_R.Osagaia_Jarri( M, 1,1, Cos(A, 360.0));
            Matrizeak_R.Osagaia_Jarri( M, 1,2, Sin(A, 360.0));
            Matrizeak_R.Osagaia_Jarri( M, 2,1, -Sin(A, 360.0));
            Matrizeak_R.Osagaia_Jarri( M, 2,2, Cos(A, 360.0));

            P0 := Matrizeak_R.Biderkadura (M, P);
         elsif  Transf ="ih" then
            -- M matrizeak islapen horizontala adierazten du
            -- ONDO DEFINITU M MATRIZEA TRANSFORMAZIO HONETARAKO
            Matrizeak_R.Osagaia_Jarri( M, 1,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 1,2, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,2, 1.0);

            P0 := Matrizeak_R.Biderkadura (M, P);
         elsif Transf ="ib" then
            -- M matrizeak islapen bertikala adierazten du
            -- ONDO DEFINITU M MATRIZEA TRANSFORMAZIO HONETARAKO
            Matrizeak_R.Osagaia_Jarri( M, 1,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 1,2, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,2, 1.0);

            P0 := Matrizeak_R.Biderkadura (M, P);
         elsif Transf ="dh" then
            -- M matrizeak distortsio horizontala adierazten du
            -- ONDO DEFINITU M MATRIZEA TRANSFORMAZIO HONETARAKO
            Matrizeak_R.Osagaia_Jarri( M, 1,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 1,2, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,2, 1.0);

            P0 := Matrizeak_R.Biderkadura (M, P);
         elsif Transf ="db" then
            -- M matrizeak distortsio bertikala adierazten du
            -- ONDO DEFINITU M MATRIZEA TRANSFORMAZIO HONETARAKO
            Matrizeak_R.Osagaia_Jarri( M, 1,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 1,2, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,2, 1.0);

           P0 := Matrizeak_R.Biderkadura (M, P);
         elsif Transf ="i4" then
            -- M matrizeak y=x zuzenarekiko islapena adierazten du
            -- ONDO DEFINITU M MATRIZEA TRANSFORMAZIO HONETARAKO
            Matrizeak_R.Osagaia_Jarri( M, 1,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 1,2, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,1, 1.0);
            Matrizeak_R.Osagaia_Jarri( M, 2,2, 1.0);

            P0 := Matrizeak_R.Biderkadura (M, P);
         elsif Transf ="th" then
            -- ONDO DEFINITU P0 puntuaren koordenatuak P-renak
            --   eta translazioaren paramteroa erabilita

            P0 := P;  --EGOKITZEKO
         elsif Transf ="tb" then
            -- ONDO DEFINITU P0 puntuaren koordenatuak P-renak
            --   eta translazioaren paramteroa erabilita

            P0 := P;  --EGOKITZEKO
         end if;

         Koordenatuak_R.Jatorri_aldaketa( P0_H, P0, -Float(I_Erdian), -Float(J_Erdian));

      end Bilatu_Zein_Pixel_Kopiatu_Behar_Den;

      procedure Kopiatu_Pixela( Berria :  in out Irudi;
                                I1, J1 :  in     Integer ;
                                Irudia :  in     Irudi;
                                P0_H   :  in     Koordenatuak_R.Koordenatu) is
         --Aurre:
         --Post: Berria irudiko (I1,J1) pixelean balio berria jarri da:
         --         Irudia irudiaren PO_H koordenatuko pixela,
         --      baina 128 kolorea jarri da PO_H koordenatua iruditik kanpo badago
      begin
         I0 := Integer(Koordenatuak_R.Osagaiak( P0, 1));
         J0 := Integer(Koordenatuak_R.Osagaiak( P0, 2));
         -- (I0,J0) puntua jatorrizko iruditik kanpo bazegoen 128 kolorea jarri.
         if (1<=I0+I_Erdian) and (I0+I_Erdian<=Irudia.Altuera)
           and (1<=J0+J_Erdian) and (J0+J_Erdian<=Irudia.Zabalera)
         then
            Berria.Pixelak(I1,J1):= Irudia.Pixelak(I0+I_Erdian,J0+J_Erdian);
         else
            Berria.Pixelak(I1,J1):= Fondoko_Kolorea;
         end if;
      end Kopiatu_Pixela;

   begin
      Berria.Zabalera:= Irudia.Zabalera;
      Berria.Altuera:= Irudia.Altuera;
      Berria.Kolore_Kop:= Irudia.Kolore_Kop;

      for I1 in 1..Berria.Altuera   loop
         for J1 in 1..Berria.Zabalera   loop
            --Lortu zein koordenatu dagokion irudi berriko (I1,J1) puntuari
            --jatorrizko irudian
            Bilatu_Zein_Pixel_Kopiatu_Behar_Den (Irudia, I1, J1, P0_H, Transf, A);
            --Kopiatu_Pixela
            Kopiatu_Pixela (Berria, I1, J1, Irudia, P0_H);
         end loop;
      end loop;
   end Transformazioa;


   procedure Txertatu_Koadroa
     (Irudia : in out Irudi;
      Irudi1 : in     Irudi;
      X,Y    : in     Integer ) is
   begin
      for I in 1..Irudi1.Zabalera loop
         --Put('.');  Put(I, 4);
         for J in 1..Irudi1.Altuera loop
            --put(Irudia.Pixelak(I, J), 5); new_line; skip_line;
            Irudia.Pixelak(X+I, Y+J):= Irudi1.Pixelak(I, J);
         end loop;
      end loop;
   end Txertatu_Koadroa;

   procedure Berdimentsionatu (
                               Irudia    : in      Irudi;
                               Zabalera,
                               Altuera : in        Integer;
                               Berria    :     out Irudi  ) is
      I_Zaharrean, J_Zaharrean : Integer;
      Zabalera1, Altuera1 : Integer;
   begin
      if Zabalera <1                 then Zabalera1 := 1;
      elsif Zabalera > Max_Zabalera  then Zabalera1 := Max_Zabalera;
      else                                Zabalera1 := Zabalera;
      end if;
      if Altuera <1                  then Altuera1 := 1;
      elsif Altuera > Max_Altuera    then Altuera1 := Max_Altuera;
      else                                Altuera1 := Altuera;
      end if;

      Berria.Zabalera := Zabalera1;
      Berria.Altuera  := Altuera1;
      --      Put(Berria.Zabalera);Put (Berria.Altuera); New_Line;
      Berria.Kolore_Kop := Irudia.Kolore_Kop;

      for I in 1..Berria.Altuera loop
         I_Zaharrean := Integer (Float(Irudia.Altuera * I)/Float(Altuera1));
         if I_Zaharrean=0               then I_Zaharrean:=1; end if;
         if I_Zaharrean>Irudia.Altuera then I_Zaharrean:=Irudia.Altuera; end if;
         for J in 1..Berria.Zabalera loop
            --put(Irudia.Pixelak(I, J), 5); new_line; skip_line;
            J_Zaharrean := Integer( (Float(Irudia.Zabalera)*Float(J))/Float(Zabalera1));
            if J_Zaharrean=0              then J_Zaharrean:=1; end if;
            if J_Zaharrean>Irudia.Zabalera then J_Zaharrean:=Irudia.Zabalera; end if;
            --Put(I,4);put(I_zaharrean,4); put(j,4);  Put(J_zaharrean, 4);New_line;
            Berria.Pixelak(I, J):= Irudia.Pixelak(I_Zaharrean, J_Zaharrean);
         end loop;
      end loop;
   end Berdimentsionatu;

   procedure Irudia_Zuritan_Sortu( Ir: out Irudi) is
      -- Post: dimentsio handienetako irudi bat sortzen du
      --      pixel guztietan 250 kolorea duena
   begin
      Ir :=
        (Max_Zabalera,
         Max_Altuera,
         Max_Kolore,
         (1 .. Max_Zabalera=> (1 .. Max_Altuera=>250)));

   end Irudia_Zuritan_Sortu;


end Irudiak;

