with Koordenatuak_R ;
package  Matrizeak_R is

   type Matrize is  private;
   N : constant Integer := 2;
   subtype Indize is Integer range 1..N;



   function Osagaiak (M1: in Matrizeak_R.Matrize;
                      I, J: in Matrizeak_R.Indize)
                     return Float ;

   procedure Osagaia_Jarri (M1:     in out Matrizeak_R.Matrize;
                           I, J:   in Matrizeak_R.Indize;
                           Balioa: in Float) ;

   function Batura (M1, M2: in Matrizeak_R.Matrize)
                   return Matrizeak_R.Matrize ;
      -- Aurrebaldintza: M1 eta M2 2x2 dimentsioko matrizeak_r dira
      -- Postbaldintza: emaitza M1 eta M2ren batura;

   function Biderkadura(K : in Float;
                        M1: in Matrizeak_R.Matrize)
                       return Matrizeak_R.Matrize ;
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da
      -- Postbaldintza: emaitza K zenbakiaren eta M1 matrizearen
      --    arteko biderkadura da

   function Biderkadura (M1, M2  : in Matrizeak_R.Matrize)
                         return Matrizeak_R.Matrize ;
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da eta
      --   M2 PxN dimentsioko matrizea da
      -- Postbaldintza: emaitza M1 eta M2ren biderkadura da

   function Biderkadura (M1  : in Matrizeak_R.Matrize;
                         P   : in Koordenatuak_R.Koordenatu)
                        return Koordenatuak_R.Koordenatu ;
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da eta
      --   P  Koordenatuak motako da (1x2 matrizea)
      -- Postbaldintza: emaitza M1 eta Pren biderkadura da
      --   eta Koordenatuak motakoa;


   procedure Matrizea_Idatzi (M1: in Matrizeak_R.Matrize) ;
   --     -- Aurrebaldintza: M1 M xN dimentsioko matrizea da
   --     -- Postbaldintza: M1 matrizearen inpresioa;


   procedure Matrizea_Irakurri (M1: out Matrizeak_R.Matrize) ;
   --     -- Aurrebaldintza: N eta N irakurri nahi den matrizearen
   --     --    dimentsioa ematen dute.
   --     -- Postbaldintza: M1 matrizea sarrerako datuekin eratuta;



private

   type Matrize is array (Indize, Indize) of Float;

end Matrizeak_R;
