with Ada.Float_Text_IO, Ada.Text_IO;
Package body Matrizeak_R is

   function Osagaiak (M1: in Matrizeak_R.Matrize;
                      I, J: in Indize)
                     return  Float is
      -- Aurre:
      -- Post:
   begin
      return M1 (I,J);
   end Osagaiak;

   procedure Osagaia_Jarri (M1:    in out Matrizeak_R.Matrize;
                           I, J:   in     Matrizeak_R.Indize;
                           Balioa: in     Float) is
      -- Aurre:
      -- Post:
   begin
      M1 (I,J) := Balioa;
   end Osagaia_Jarri;

   function Batura (M1, M2: in Matrizeak_R.Matrize)
                   return Matrizeak_R.Matrize is
      -- Aurrebaldintza: M1 eta M2 2x2 dimentsioko matrizeak_r dira
      -- Postbaldintza: emaitza M1 eta M2ren batura;
      Emaitza : Matrizeak_R.Matrize;
      --Batura: Float;
   begin
      for I in 1 .. N loop
         for J in 1 .. N loop
            -- OSATZEKO hasiera

            Matrizeak_R.Osagaia_Jarri (Emaitza, I, J, 0.0);

            -- OSATZEKO bukaera
         end loop;
      end loop;
      return Emaitza;
   end Batura;

   function Biderkadura(K : in Float;
                        M1: in Matrizeak_R.Matrize)
                       return Matrizeak_R.Matrize is
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da
      -- Postbaldintza: emaitza K zenbakiaren eta M1 matrizearen
      --    arteko biderkadura da
      Emaitza : Matrizeak_R.Matrize;
      --Osagaia : Float;
   begin
      for I in 1 .. N loop
         for J in 1 .. N loop
            -- OSATZEKO hasiera

            Matrizeak_R.Osagaia_Jarri (Emaitza, I, J, 0.0);

            -- OSATZEKO bukaera
         end loop;
      end loop;
      return Emaitza;
   end Biderkadura;

   function Biderkadura (M1, M2  : in Matrizeak_R.Matrize)
                         return Matrizeak_R.Matrize is
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da eta
      --   M2 PxN dimentsioko matrizea da
      -- Postbaldintza: emaitza M1 eta M2ren biderkadura da
      Emaitza : Matrizeak_R.Matrize ;
      --Batura :Float;
   begin
      for I in 1 .. N loop
         for J in 1 .. N loop
            -- OSATZEKO hasiera

            Matrizeak_R.Osagaia_Jarri (Emaitza, I, J, 0.0);

            -- OSATZEKO bukaera
         end loop;
      end loop;
      return Emaitza;
   end Biderkadura;

   function Biderkadura (M1  : in Matrizeak_R.Matrize;
                         P   : in Koordenatuak_R.Koordenatu)
                         return Koordenatuak_R.Koordenatu is
      -- Aurrebaldintza: M1 2x2 dimentsioko matrizea da eta
      --   P  Koordenatuak motako da (1x2 matrizea)
      -- Postbaldintza: emaitza M1 eta Pren biderkadura da
      --   eta Koordenatuak motakoa;
      Emaitza : Koordenatuak_R.Koordenatu ;
      Batura: Float;
   begin
      for I in 1 .. N loop
         Batura := 0.0;
         for K in 1 .. N loop
            -- OSATZEKO hasiera
            Batura := 0.0;
            null;


            -- OSATZEKO bukaera
         end loop;
            Koordenatuak_R.Osagaia_Jarri (Emaitza, I, Batura);
      end loop;
      return Emaitza;
   end Biderkadura;

   procedure Matrizea_Idatzi (M1: in Matrizeak_R.Matrize) is
   --     -- Aurrebaldintza: M1 M xN dimentsioko matrizea da
   --     -- Postbaldintza: M1 matrizearen inpresioa;
   begin
      for I in 1 .. N loop
         for J in 1 .. N loop
            Ada.Float_Text_Io.Put (M1 (I, J), 5, 1, 0);
         end loop;
         Ada.Text_Io.New_Line ;
      end loop;
   end Matrizea_Idatzi;

   procedure Matrizea_Irakurri (M1: out Matrizeak_R.Matrize) is
   --     -- Aurrebaldintza: N eta N irakurri nahi den matrizearen
   --     --    dimentsioa ematen dute.
   --     -- Postbaldintza: M1 matrizea sarrerako datuekin eratuta;
   begin
      for I in 1 .. N loop
     for J in 1 .. N loop
       Ada.Float_Text_Io.Get (M1 (I, J));
     end loop;

      end loop;
   end Matrizea_Irakurri;

end Matrizeak_R;
