/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private JScrollBar scrollBar;
    private boolean initialized = false;
    private boolean localInitialize = false;

    public JMonthChooser() {
        this(0);
    }

    public JMonthChooser(int n) {
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.add((Component)this.comboBox, "Center");
        if (n != 2) {
            this.scrollBar = new JScrollBar(1, 0, 0, -10000, 10000);
            this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.getPreferredSize().height));
            this.scrollBar.setVisibleAmount(0);
            this.scrollBar.addAdjustmentListener(this);
            if (n == 0) {
                this.add((Component)this.scrollBar, "East");
            } else {
                this.add((Component)this.scrollBar, "West");
            }
        }
        this.initialized = true;
        this.setMonth(Calendar.getInstance().get(2));
    }

    public void initNames() {
        this.localInitialize = true;
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        if (this.comboBox.getItemCount() == 12) {
            this.comboBox.removeAllItems();
        }
        int n = 0;
        while (n < 12) {
            this.comboBox.addItem(stringArray[n]);
            ++n;
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.comboBox.getSelectedIndex();
        if (n >= 0) {
            this.setMonth(n, false);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl = true;
        int n = adjustmentEvent.getValue();
        if (n > this.oldScrollBarValue) {
            bl = false;
        }
        this.oldScrollBarValue = n;
        int n2 = this.getMonth();
        if (bl) {
            if (++n2 == 12) {
                n2 = 0;
                if (this.yearChooser != null) {
                    int n3 = this.yearChooser.getYear();
                    this.yearChooser.setYear(++n3);
                }
            }
        } else if (--n2 == -1) {
            n2 = 11;
            if (this.yearChooser != null) {
                int n4 = this.yearChooser.getYear();
                this.yearChooser.setYear(--n4);
            }
        }
        this.setMonth(n2);
    }

    private void setMonth(int n, boolean bl) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int n2 = this.month;
        this.month = n;
        if (bl) {
            this.comboBox.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n2, this.month);
    }

    public void setMonth(int n) {
        this.setMonth(n, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jDayChooser) {
        this.dayChooser = jDayChooser;
    }

    public void setYearChooser(JYearChooser jYearChooser) {
        this.yearChooser = jYearChooser;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.initNames();
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.comboBox.setEnabled(bl);
        if (this.scrollBar != null) {
            this.scrollBar.setEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("MonthChooser");
        jFrame.getContentPane().add(new JMonthChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

