// lanzador-vigilante.c
// Un lanzador de programas con control de tiempos
/////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

int main (int argc, const char * argv[]) {
    int i, id;

    if (argc <= 2) {
       fprintf(stderr, "Uso: %s timeout programa_1 ... programa_N\n", argv[0]);
       exit(1);
    }

    for (i=2; i<argc; i++) {
      switch (fork()) {
      case -1:
        perror("fork");
        exit(1);
      case 0:
        if (execlp("./controlador", "./controlador", argv[1], argv[i], NULL) == -1) {
           fprintf(stderr, "El controlador no se ha podido ejecutar\n");
           continue;
        }
      }
    }
    while ((id=wait(NULL)) != (-1)) ;
}