// controlador.c
// Un lanzador de programas con control de tiempos
/////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

int main (int argc, const char * argv[]) {
    int i, id, id1, id2;

    if (argc != 3) {
       fprintf(stderr, "Uso: %s timeout programa\n", argv[0]);
       exit(1);
    }

           switch ((id1=fork())) {
               case -1:
                   perror("fork");
                   exit(1);
               case 0: 
                   if (execlp("sleep", "sleep", argv[1], NULL) == -1) {
                      fprintf(stderr, "El programa %s no se ha podido ejecutar\n", argv[i]);
                      exit(1);
                   }
           }
           switch ((id2=fork())) {
               case -1:
                   perror("fork");
                   exit(1);
               case 0:
                   if (execlp(argv[2], argv[2], NULL) == -1) {
                      fprintf(stderr, "El programa %s no se ha podido ejecutar\n", argv[2]);
                      exit(1);
                   }
           }

           if ((id=wait(NULL)) == id1) {
              kill(id2, SIGKILL);
              fprintf(stderr, "Abortado %i %s\n", id2, argv[2]);
           }
           else {
              kill(id1, SIGKILL);
              fprintf(stderr, "Terminado %i %s\n", id2, argv[2]);
           }
           wait(NULL);
}
