// mcpv.c
// 
// Genera una secuencia entrelazada de valores de entrada para el filtro vida.
//
// No es compatible con MacOS
/////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>
#include <semaphore.h>
#include "buffer_circular.h"

#define SENSORES 3
#define OUTPUTS 40
#define PARA_CIFRAR "para_cifrar"

#define DURACION_POR_DEFECTO 10

char *sensor[SENSORES];
char POS[]= "dev/pos";
char CO2[]= "dev/CO2";
char H2O[]= "dev/H2O";

pthread_t tr, tc, tp[SENSORES];

pthread_mutex_t mutex_bc;

sem_t huecos, items;     // Para control del buffer

int duracion;


void* reloj() 
{
    sleep(duracion);
}



void* productor(char* f) {

    char input;
    int fd, n;

    if ((fd= open(f, O_RDWR)) < 0) {
        fprintf(stderr, "Error al abrir para lectura: %s\n", f);
        exit(3);
    }
    while ((n= read(fd, &input, 1)) > 0) {
        sem_wait(&huecos);           
	pthread_mutex_lock(&mutex_bc);
        insertar(input);
	pthread_mutex_unlock(&mutex_bc);
        sem_post(&items);
    };
}

void* consumidor() {

    char output;
    int fd, k;

    if ((fd= open(PARA_CIFRAR, O_WRONLY|O_CREAT, 0660)) < 0) {
        fprintf(stderr, "No se puede abrir para escritura %s\n", PARA_CIFRAR);
        exit(2);
    }

    for (k=0; k<OUTPUTS; k++) {
        sem_wait(&items);           
        pthread_mutex_lock(&mutex_bc);
        if (!retirar(&output)) {
           fprintf(stderr, "Algo va mal en el buffer...\n");
        }
        pthread_mutex_unlock(&mutex_bc);
        sem_post(&huecos);
        write(fd, &output, 1);         // Para cifrar
        write(1, &output, 1);          // Para el modulo vida
    }
}

int main(int argc, char* argv[])
{
    int i, k, e, max_prods= SENSORES;

    if (argc == 1) duracion= DURACION_POR_DEFECTO;
    if (argc == 2) duracion= atoi(argv[1]);
    if (argc > 2) {
       fprintf(stderr, "Uso: %s [duracion]\n", argv[0]);
       exit(1);
    }
    fprintf(stderr, "Duracion: %d segundos\n", duracion);

    sensor[0]= POS;
    sensor[1]= CO2;
    sensor[2]= H2O;

    if (sem_init(&huecos, 0, TAM_BUFFER) != 0) {
       fprintf(stderr, "No puedo iniciar el semaforo huecos\n");
       exit(4);
    }
    if (sem_init(&items, 0, 0) != 0) {
       fprintf(stderr, "No puedo iniciar el semaforo items\n");
       exit(4);
    }

    for (i=0; i<max_prods; i++) {
        if (pthread_create(&tp[i], NULL, productor, sensor[i]) != 0) {
            fprintf(stderr, "Error al crear thread para el sensor %s\n", sensor[i]);
            exit(2);
        };
    }
    if (pthread_create(&tc, NULL, consumidor, NULL) != 0) {
        fprintf(stderr, "Error al crear thread consumidor\n");
        exit(2);
    };
    if (pthread_create(&tr, NULL, reloj, NULL) != 0) {
        fprintf(stderr, "Error al crear thread reloj\n");
        exit(2);
    };

    if (pthread_join(tr, NULL) != 0) {
        fprintf(stderr, "Error esperando al thread reloj\n");
        exit(2);
    };

    printf("Bye\n");

    printf("\n");
}