// sencriptador.c
// 
// Cifra un fichero de texto con una clave y lo escribe por la salida estandar.
// Versión con llamadas al sistema
/////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>

#define CLAVE 0x01  // La clave

#define TAMANO_BUFFER 1

main (int argc, char* argv[])
{
    int n;
    char buf[TAMANO_BUFFER];
    int fd;
    char c;
    char clave= CLAVE;

    if ((clave<0x00) || (clave>0x0f)) {
       fprintf(stderr, "La clave debe estar entre 0 y 15\n");
       exit(1);
    }

    if (argc != 2) {
        fprintf(stderr, "Uso: %s salida-cifrada\n", argv[0]);
        exit(1);
    }

    if ((fd= open(argv[1], O_WRONLY|O_CREAT, 0660)) < 0) {
        fprintf(stderr, "No se puede abrir para escritura %s\n", argv[1]);
        exit(2);
    }

    while ((n= read(0, buf, TAMANO_BUFFER)) > 0) {
        write(1, buf, 1);
        if (buf[0]=='\n') write(fd, buf, 1);
        else {
           c= buf[0]^clave;
           write(fd, &c, 1);
        }
    }
}
