// cencriptador.c
// 
// Cifra un fichero de texto con una clave y lo escribe por la salida estandar.
// Versión con funciones de biblioteca de E-S
/////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>

#define CLAVE 0x01  // La clave

//#define MASK 0x0f

main (int argc, char* argv[])
{
    FILE* fd;
    int c;
    char clave= CLAVE;
    
    if ((clave<0x00) || (clave>0x0f)) {
       fprintf(stderr, "La clave debe estar entre 0 y 15\n");
       exit(1);
    }

    if (argc != 2) {
        fprintf(stderr, "Uso: %s salida-cifrada\n", argv[0]);
        exit(1);
    }

    if ((fd= fopen(argv[1], "w")) == NULL) {
        fprintf(stderr, "No se puede abrir para escritura en %s\n", argv[1]);
        exit(2);
    }

    while ((c=getchar()) != EOF) {
        putc(c, stdout);
        if (c=='\n') putc('\n', fd);
        else putc(c^clave, fd);
    }
}
