/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.bloat;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.instrumentation.api.InstrumentationException;
import com.db4o.instrumentation.api.MethodRef;
import com.db4o.instrumentation.api.NativeClassFactory;
import com.db4o.instrumentation.api.ReferenceResolver;
import com.db4o.instrumentation.api.TypeRef;
import java.lang.reflect.Method;

public class BloatReferenceResolver
implements ReferenceResolver {
    private final NativeClassFactory _loader;

    public BloatReferenceResolver(NativeClassFactory loader) {
        if (null == loader) {
            throw new ArgumentNullException();
        }
        this._loader = loader;
    }

    public Method resolve(MethodRef methodRef) {
        Class declaringClass = this.resolve(methodRef.declaringType());
        Class[] paramTypes = this.resolve(methodRef.paramTypes());
        try {
            return declaringClass.getDeclaredMethod(methodRef.name(), paramTypes);
        }
        catch (Exception e) {
            throw new InstrumentationException(e);
        }
    }

    private Class[] resolve(TypeRef[] paramTypes) {
        Class[] classes = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            classes[i] = this.resolve(paramTypes[i]);
        }
        return classes;
    }

    private Class resolve(TypeRef typeRef) {
        try {
            return this._loader.forName(typeRef.name());
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentationException(e);
        }
    }
}

