/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.jdk;

import com.db4o.internal.Platform4;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.core.ConstructorSupport;
import com.db4o.reflect.core.ReflectConstructor;
import com.db4o.reflect.core.ReflectConstructorSpec;
import com.db4o.reflect.jdk.JavaReflectClass;
import com.db4o.reflect.jdk.JdkConstructor;
import com.db4o.reflect.jdk.JdkField;
import com.db4o.reflect.jdk.JdkMethod;
import com.db4o.reflect.jdk.JdkReflector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JdkClass
implements JavaReflectClass {
    protected final Reflector _reflector;
    private final JdkReflector _jdkReflector;
    private final Class _clazz;
    private ReflectConstructorSpec _constructorSpec;

    public JdkClass(Reflector reflector, JdkReflector jdkReflector, Class clazz) {
        if (jdkReflector == null) {
            throw new NullPointerException();
        }
        if (reflector == null) {
            throw new NullPointerException();
        }
        this._reflector = reflector;
        this._clazz = clazz;
        this._jdkReflector = jdkReflector;
        this._constructorSpec = ReflectConstructorSpec.UNSPECIFIED_CONSTRUCTOR;
    }

    public ReflectClass getComponentType() {
        return this._reflector.forClass(this._clazz.getComponentType());
    }

    private ReflectConstructor[] getDeclaredConstructors() {
        try {
            Constructor<?>[] constructors = this._clazz.getDeclaredConstructors();
            ReflectConstructor[] reflectors = new ReflectConstructor[constructors.length];
            for (int i = 0; i < constructors.length; ++i) {
                reflectors[i] = new JdkConstructor(this._reflector, constructors[i]);
            }
            return reflectors;
        }
        catch (NoClassDefFoundError exc) {
            return new ReflectConstructor[0];
        }
    }

    public ReflectField getDeclaredField(String name) {
        try {
            return this.createField(this._clazz.getDeclaredField(name));
        }
        catch (Exception e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    protected JdkField createField(Field field) {
        return new JdkField(this._reflector, field);
    }

    public ReflectField[] getDeclaredFields() {
        try {
            Field[] fields = this._clazz.getDeclaredFields();
            ReflectField[] reflectors = new ReflectField[fields.length];
            for (int i = 0; i < reflectors.length; ++i) {
                reflectors[i] = this.createField(fields[i]);
            }
            return reflectors;
        }
        catch (NoClassDefFoundError exc) {
            return new ReflectField[0];
        }
    }

    public ReflectClass getDelegate() {
        return this;
    }

    public ReflectMethod getMethod(String methodName, ReflectClass[] paramClasses) {
        try {
            Method method = this._clazz.getMethod(methodName, JdkReflector.toNative(paramClasses));
            if (method == null) {
                return null;
            }
            return new JdkMethod(method, this.reflector());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this._clazz.getName();
    }

    public ReflectClass getSuperclass() {
        return this._reflector.forClass(this._clazz.getSuperclass());
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this._clazz.getModifiers());
    }

    public boolean isArray() {
        return this._clazz.isArray();
    }

    public boolean isAssignableFrom(ReflectClass type) {
        if (!(type instanceof JavaReflectClass)) {
            return false;
        }
        return this._clazz.isAssignableFrom(JdkReflector.toNative(type));
    }

    public boolean isCollection() {
        return this._reflector.isCollection(this);
    }

    public boolean isInstance(Object obj) {
        return this._clazz.isInstance(obj);
    }

    public boolean isInterface() {
        return this._clazz.isInterface();
    }

    public boolean isPrimitive() {
        return this._clazz.isPrimitive();
    }

    public Object newInstance() {
        this.createConstructor();
        return this._constructorSpec.newInstance();
    }

    public Class getJavaClass() {
        return this._clazz;
    }

    public Reflector reflector() {
        return this._reflector;
    }

    public ReflectConstructor getSerializableConstructor() {
        Constructor serializableConstructor = Platform4.jdk().serializableConstructor(this._clazz);
        if (serializableConstructor == null) {
            return null;
        }
        return new JdkConstructor(this._reflector, serializableConstructor);
    }

    public Object nullValue() {
        return this._jdkReflector.nullValue(this);
    }

    private void createConstructor() {
        if (!this._constructorSpec.canBeInstantiated().isUnspecified()) {
            return;
        }
        this._constructorSpec = ConstructorSupport.createConstructor(this, this._clazz, this._jdkReflector.configuration(), this.getDeclaredConstructors());
    }

    public boolean ensureCanBeInstantiated() {
        this.createConstructor();
        return this._constructorSpec.canBeInstantiated().definiteYes();
    }
}

