/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.marshall.AspectType;
import com.db4o.internal.marshall.FieldMarshaller0;
import com.db4o.internal.marshall.RawFieldSpec;

public class FieldMarshaller1
extends FieldMarshaller0 {
    private boolean hasBTreeIndex(FieldMetadata field) {
        return !field.isVirtual();
    }

    public void write(Transaction trans, ClassMetadata clazz, ClassAspect aspect, ByteArrayBuffer writer) {
        super.write(trans, clazz, aspect, writer);
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        FieldMetadata field = (FieldMetadata)aspect;
        if (!this.hasBTreeIndex(field)) {
            return;
        }
        writer.writeIDOf(trans, field.getIndex(trans));
    }

    protected RawFieldSpec readSpec(AspectType aspectType, ObjectContainerBase stream, ByteArrayBuffer reader) {
        RawFieldSpec spec = super.readSpec(aspectType, stream, reader);
        if (spec == null) {
            return null;
        }
        if (spec.isVirtual()) {
            return spec;
        }
        int indexID = reader.readInt();
        spec.indexID(indexID);
        return spec;
    }

    protected FieldMetadata fromSpec(RawFieldSpec spec, ObjectContainerBase stream, FieldMetadata field) {
        FieldMetadata actualField = super.fromSpec(spec, stream, field);
        if (spec == null) {
            return field;
        }
        if (spec.indexID() != 0) {
            actualField.initIndex(stream.systemTransaction(), spec.indexID());
        }
        return actualField;
    }

    public int marshalledLength(ObjectContainerBase stream, ClassAspect aspect) {
        int len = super.marshalledLength(stream, aspect);
        if (!(aspect instanceof FieldMetadata)) {
            return len;
        }
        FieldMetadata field = (FieldMetadata)aspect;
        if (!this.hasBTreeIndex(field)) {
            return len;
        }
        int BTREE_ID = 4;
        return len + 4;
    }

    public void defrag(ClassMetadata classMetadata, ClassAspect aspect, LatinStringIO sio, DefragmentContextImpl context) {
        super.defrag(classMetadata, aspect, sio, context);
        if (!(aspect instanceof FieldMetadata)) {
            return;
        }
        FieldMetadata field = (FieldMetadata)aspect;
        if (field.isVirtual()) {
            return;
        }
        if (field.hasIndex()) {
            BTree index = field.getIndex(context.systemTrans());
            int targetIndexID = context.copyID();
            if (targetIndexID != 0) {
                index.defragBTree(context.services());
            }
        } else {
            context.writeInt(0);
        }
    }
}

