/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.DTrace;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.TreeReader;
import com.db4o.internal.freespace.AbstractFreespaceManager;
import com.db4o.internal.freespace.FreeSlotNode;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;

public class RamFreespaceManager
extends AbstractFreespaceManager {
    private final TreeIntObject _finder = new TreeIntObject(0);
    private Tree _freeByAddress;
    private Tree _freeBySize;

    public RamFreespaceManager(LocalObjectContainer file) {
        super(file);
    }

    private void addFreeSlotNodes(int address, int length) {
        FreeSlotNode addressNode = new FreeSlotNode(address);
        addressNode.createPeer(length);
        this._freeByAddress = Tree.add(this._freeByAddress, addressNode);
        this._freeBySize = Tree.add(this._freeBySize, addressNode._peer);
    }

    public Slot allocateTransactionLogSlot(int length) {
        FreeSlotNode sizeNode = (FreeSlotNode)Tree.last(this._freeBySize);
        if (sizeNode == null || sizeNode._key < length) {
            return null;
        }
        int limit = length + 100;
        if (sizeNode._key > limit) {
            return this.getSlot(limit);
        }
        this.removeFromBothTrees(sizeNode);
        return new Slot(sizeNode._peer._key, sizeNode._key);
    }

    public void freeTransactionLogSlot(Slot slot) {
        this.free(slot);
    }

    public void beginCommit() {
    }

    public void commit() {
    }

    public void endCommit() {
    }

    public void free(Slot slot) {
        int address = slot.address();
        int length = slot.length();
        if (address <= 0) {
            throw new IllegalArgumentException();
        }
        if (DTrace.enabled) {
            DTrace.FREESPACEMANAGER_RAM_FREE.logLength(address, length);
        }
        this._finder._key = address;
        FreeSlotNode addressnode = (FreeSlotNode)Tree.findSmaller(this._freeByAddress, this._finder);
        if (addressnode != null && addressnode._key + addressnode._peer._key == address) {
            FreeSlotNode sizeNode = addressnode._peer;
            this._freeBySize = this._freeBySize.removeNode(sizeNode);
            sizeNode._key += length;
            FreeSlotNode secondAddressNode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (secondAddressNode != null && address + length == secondAddressNode._key) {
                sizeNode._key += secondAddressNode._peer._key;
                this.removeFromBothTrees(secondAddressNode._peer);
            }
            sizeNode.removeChildren();
            this._freeBySize = Tree.add(this._freeBySize, sizeNode);
        } else {
            addressnode = (FreeSlotNode)Tree.findGreaterOrEqual(this._freeByAddress, this._finder);
            if (addressnode != null && address + length == addressnode._key) {
                FreeSlotNode sizeNode = addressnode._peer;
                this.removeFromBothTrees(sizeNode);
                sizeNode._key += length;
                addressnode._key = address;
                addressnode.removeChildren();
                sizeNode.removeChildren();
                this._freeByAddress = Tree.add(this._freeByAddress, addressnode);
                this._freeBySize = Tree.add(this._freeBySize, sizeNode);
            } else {
                if (this.canDiscard(length)) {
                    return;
                }
                this.addFreeSlotNodes(address, length);
            }
        }
        this._file.overwriteDeletedBlockedSlot(slot);
    }

    public void freeSelf() {
    }

    private void freeReader(StatefulBuffer reader) {
        this._file.free(reader.getAddress(), reader.length());
    }

    public Slot getSlot(int length) {
        this._finder._key = length;
        this._finder._object = null;
        this._freeBySize = FreeSlotNode.removeGreaterOrEqual((FreeSlotNode)this._freeBySize, this._finder);
        if (this._finder._object == null) {
            return null;
        }
        FreeSlotNode node = (FreeSlotNode)this._finder._object;
        int blocksFound = node._key;
        int address = node._peer._key;
        this._freeByAddress = this._freeByAddress.removeNode(node._peer);
        int remainingBlocks = blocksFound - length;
        if (this.canDiscard(remainingBlocks)) {
            length = blocksFound;
        } else {
            this.addFreeSlotNodes(address + length, remainingBlocks);
        }
        if (DTrace.enabled) {
            DTrace.FREESPACEMANAGER_GET_SLOT.logLength(address, length);
        }
        return new Slot(address, length);
    }

    int marshalledLength() {
        return TreeInt.marshalledLength((TreeInt)this._freeBySize);
    }

    public void read(int freeSlotsID) {
        this.readById(freeSlotsID);
    }

    private void read(StatefulBuffer reader) {
        FreeSlotNode.sizeLimit = this.blockedDiscardLimit();
        this._freeBySize = new TreeReader(reader, new FreeSlotNode(0), true).read();
        final Tree.ByRef addressTree = new Tree.ByRef();
        if (this._freeBySize != null) {
            this._freeBySize.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    FreeSlotNode node = ((FreeSlotNode)a_object)._peer;
                    addressTree.value = Tree.add(addressTree.value, node);
                }
            });
        }
        this._freeByAddress = addressTree.value;
    }

    void read(Slot slot) {
        if (slot.address() == 0) {
            return;
        }
        StatefulBuffer reader = this._file.readWriterByAddress(this.transaction(), slot.address(), slot.length());
        if (reader == null) {
            return;
        }
        this.read(reader);
        this.freeReader(reader);
    }

    private void readById(int freeSlotsID) {
        if (freeSlotsID <= 0) {
            return;
        }
        if (this.discardLimit() == Integer.MAX_VALUE) {
            return;
        }
        StatefulBuffer reader = this._file.readWriterByID(this.transaction(), freeSlotsID);
        if (reader == null) {
            return;
        }
        this.read(reader);
        this._file.free(freeSlotsID, 8);
        this.freeReader(reader);
    }

    private void removeFromBothTrees(FreeSlotNode sizeNode) {
        this._freeBySize = this._freeBySize.removeNode(sizeNode);
        this._freeByAddress = this._freeByAddress.removeNode(sizeNode._peer);
    }

    public int slotCount() {
        return Tree.size(this._freeByAddress);
    }

    public void start(int slotAddress) {
    }

    public byte systemType() {
        return 2;
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("RAM FreespaceManager\n");
        sb.append("Address Index\n");
        this._freeByAddress.traverse(new Visitor4(){

            public void visit(Object obj) {
                sb.append(obj);
                sb.append("\n");
            }
        });
        sb.append("Length Index\n");
        this._freeBySize.traverse(new Visitor4(){

            public void visit(Object obj) {
                sb.append(obj);
                sb.append("\n");
            }
        });
        return sb.toString();
    }

    public void traverse(final Visitor4 visitor) {
        if (this._freeByAddress == null) {
            return;
        }
        this._freeByAddress.traverse(new Visitor4(){

            public void visit(Object a_object) {
                FreeSlotNode fsn = (FreeSlotNode)a_object;
                int address = fsn._key;
                int length = fsn._peer._key;
                visitor.visit(new Slot(address, length));
            }
        });
    }

    public int write() {
        Pointer4 pointer = this._file.newSlot(this.marshalledLength());
        this.write(pointer);
        return pointer._id;
    }

    void write(Pointer4 pointer) {
        StatefulBuffer buffer = new StatefulBuffer((Transaction)this.transaction(), pointer);
        TreeInt.write(buffer, (TreeInt)this._freeBySize);
        buffer.writeEncrypt();
        this.transaction().flushFile();
        this.transaction().writePointer(pointer);
    }
}

