/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.Cool;
import com.db4o.foundation.PrimitiveCodec;
import com.db4o.internal.IoAdaptedObjectContainer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.fileheader.TimerFileLock;
import com.db4o.io.IoAdapter;

public class TimerFileLockEnabled
extends TimerFileLock {
    private final IoAdapter _timerFile;
    private final Object _timerLock;
    private byte[] _longBytes = new byte[8];
    private byte[] _intBytes = new byte[4];
    private int _headerLockOffset = 6;
    private final long _opentime;
    private int _baseAddress = -1;
    private int _openTimeOffset;
    private int _accessTimeOffset;
    private boolean _closed = false;

    public TimerFileLockEnabled(IoAdaptedObjectContainer file) {
        this._timerLock = file.lock();
        this._timerFile = file.timerFile();
        this._opentime = this.uniqueOpenTime();
    }

    public void checkHeaderLock() {
        if ((long)((int)this._opentime) != this.readInt(0, this._headerLockOffset)) {
            throw new DatabaseFileLockedException(this._timerFile.toString());
        }
        this.writeHeaderLock();
    }

    public void checkOpenTime() {
        long readOpenTime = this.readLong(this._baseAddress, this._openTimeOffset);
        if (this._opentime != readOpenTime) {
            throw new DatabaseFileLockedException(this._timerFile.toString());
        }
        this.writeOpenTime();
    }

    public void checkIfOtherSessionAlive(LocalObjectContainer container, int address, int offset, long lastAccessTime) throws Db4oIOException {
        if (this._timerFile == null) {
            return;
        }
        long waitTime = 5000L;
        long currentTime = System.currentTimeMillis();
        while (System.currentTimeMillis() < currentTime + waitTime) {
            Cool.sleepIgnoringInterruption(waitTime);
        }
        long currentAccessTime = this.readLong(address, offset);
        if (currentAccessTime > lastAccessTime) {
            throw new DatabaseFileLockedException(container.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Db4oIOException {
        this.writeAccessTime(true);
        Object object = this._timerLock;
        synchronized (object) {
            this._closed = true;
        }
    }

    public boolean lockFile() {
        return true;
    }

    public long openTime() {
        return this._opentime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = this._timerLock;
            synchronized (object) {
                if (this._closed) {
                    return;
                }
                this.writeAccessTime(false);
            }
            Cool.sleepIgnoringInterruption(1000L);
        }
    }

    public void setAddresses(int baseAddress, int openTimeOffset, int accessTimeOffset) {
        this._baseAddress = baseAddress;
        this._openTimeOffset = openTimeOffset;
        this._accessTimeOffset = accessTimeOffset;
    }

    public void start() throws Db4oIOException {
        this.writeAccessTime(false);
        this._timerFile.sync();
        this.checkOpenTime();
        Thread thread = new Thread(this);
        thread.setName("db4o file lock");
        thread.setDaemon(true);
        thread.start();
    }

    private long uniqueOpenTime() {
        return System.currentTimeMillis();
    }

    private boolean writeAccessTime(boolean closing) throws Db4oIOException {
        if (this.noAddressSet()) {
            return true;
        }
        long time = closing ? 0L : System.currentTimeMillis();
        boolean ret = this.writeLong(this._baseAddress, this._accessTimeOffset, time);
        this.sync();
        return ret;
    }

    private boolean noAddressSet() {
        return this._baseAddress < 0;
    }

    public void writeHeaderLock() {
        this.writeInt(0, this._headerLockOffset, (int)this._opentime);
        this.sync();
    }

    public void writeOpenTime() {
        this.writeLong(this._baseAddress, this._openTimeOffset, this._opentime);
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLong(int address, int offset, long time) throws Db4oIOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return false;
            }
            this._timerFile.blockSeek(address, offset);
            PrimitiveCodec.writeLong(this._longBytes, time);
            this._timerFile.write(this._longBytes);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readLong(int address, int offset) throws Db4oIOException {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return 0L;
            }
            this._timerFile.blockSeek(address, offset);
            this._timerFile.read(this._longBytes);
            return PrimitiveCodec.readLong(this._longBytes, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeInt(int address, int offset, int time) {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return false;
            }
            this._timerFile.blockSeek(address, offset);
            PrimitiveCodec.writeInt(this._intBytes, 0, time);
            this._timerFile.write(this._intBytes);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readInt(int address, int offset) {
        Object object = this._timerLock;
        synchronized (object) {
            if (this._timerFile == null) {
                return 0L;
            }
            this._timerFile.blockSeek(address, offset);
            this._timerFile.read(this._longBytes);
            return PrimitiveCodec.readInt(this._longBytes, 0);
        }
    }

    private void sync() throws Db4oIOException {
        this._timerFile.sync();
    }
}

