/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.MetaIndex;
import com.db4o.PBootRecord;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.OldFormatException;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ConfigBlock;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader;

public class FileHeader0
extends FileHeader {
    static final int HEADER_LENGTH = 18;
    private ConfigBlock _configBlock;
    private PBootRecord _bootRecord;

    public void close() throws Db4oIOException {
        this._configBlock.close();
    }

    protected FileHeader newOnSignatureMatch(LocalObjectContainer file, ByteArrayBuffer reader) {
        byte firstFileByte = reader.readByte();
        if (firstFileByte != 123) {
            if (firstFileByte != 4) {
                return null;
            }
            file.blockSizeReadFromFile(reader.readByte());
        } else if (reader.readByte() != 89) {
            return null;
        }
        return new FileHeader0();
    }

    protected void readFixedPart(LocalObjectContainer file, ByteArrayBuffer reader) throws OldFormatException {
        this._configBlock = ConfigBlock.forExistingFile(file, reader.readInt());
        this.skipConfigurationLockTime(reader);
        this.readClassCollectionAndFreeSpace(file, reader);
    }

    private void skipConfigurationLockTime(ByteArrayBuffer reader) {
        reader.incrementOffset(4);
    }

    public void readVariablePart(LocalObjectContainer file) {
        if (this._configBlock._bootRecordID <= 0) {
            return;
        }
        Object bootRecord = this.getBootRecord(file);
        if (!(bootRecord instanceof PBootRecord)) {
            this.initBootRecord(file);
            file.generateNewIdentity();
            return;
        }
        this._bootRecord = (PBootRecord)bootRecord;
        file.activate(bootRecord, Integer.MAX_VALUE);
        file.setNextTimeStampId(this._bootRecord.i_versionGenerator);
        file.systemData().identity(this._bootRecord.i_db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getBootRecord(LocalObjectContainer file) {
        file.showInternalClasses(true);
        try {
            Object object = file.getByID(file.systemTransaction(), this._configBlock._bootRecordID);
            return object;
        }
        finally {
            file.showInternalClasses(false);
        }
    }

    public void initNew(LocalObjectContainer file) throws Db4oIOException {
        this._configBlock = ConfigBlock.forNewFile(file);
        this.initBootRecord(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initBootRecord(LocalObjectContainer file) {
        file.showInternalClasses(true);
        try {
            this._bootRecord = new PBootRecord();
            file.storeInternal(file.systemTransaction(), this._bootRecord, false);
            this._configBlock._bootRecordID = file.getID(file.systemTransaction(), this._bootRecord);
            this.writeVariablePart(file, 1);
        }
        finally {
            file.showInternalClasses(false);
        }
    }

    public Transaction interruptedTransaction() {
        return this._configBlock.getTransactionToCommit();
    }

    public void writeTransactionPointer(Transaction systemTransaction, int transactionAddress) {
        this.writeTransactionPointer(systemTransaction, transactionAddress, this._configBlock.address(), 21);
    }

    public MetaIndex getUUIDMetaIndex() {
        return this._bootRecord.getUUIDMetaIndex();
    }

    public int length() {
        return 18;
    }

    public void writeFixedPart(LocalObjectContainer file, boolean startFileLockingThread, boolean shuttingDown, StatefulBuffer writer, int blockSize_, int freespaceID) {
        writer.writeByte((byte)4);
        writer.writeByte((byte)blockSize_);
        writer.writeInt(this._configBlock.address());
        writer.writeInt((int)this.timeToWrite(this._configBlock.openTime(), shuttingDown));
        writer.writeInt(file.systemData().classCollectionID());
        writer.writeInt(freespaceID);
        writer.write();
        file.syncFiles();
    }

    public void writeVariablePart(LocalObjectContainer file, int part) {
        if (part == 1) {
            this._configBlock.write();
        } else if (part == 2) {
            this._bootRecord.write(file);
        }
    }
}

