/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.DTrace;
import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.BlockingQueue;
import com.db4o.foundation.network.Socket4;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientMessageDispatcher;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.ClientSideMessage;
import com.db4o.internal.cs.messages.Msg;

class ClientMessageDispatcherImpl
extends Thread
implements ClientMessageDispatcher {
    private ClientObjectContainer _container;
    private Socket4 _socket;
    private final BlockingQueue _synchronousMessageQueue;
    private final BlockingQueue _asynchronousMessageQueue;
    private boolean _isClosed;

    ClientMessageDispatcherImpl(ClientObjectContainer client, Socket4 a_socket, BlockingQueue synchronousMessageQueue, BlockingQueue asynchronousMessageQueue) {
        this._container = client;
        this._synchronousMessageQueue = synchronousMessageQueue;
        this._asynchronousMessageQueue = asynchronousMessageQueue;
        this._socket = a_socket;
    }

    public synchronized boolean isMessageDispatcherAlive() {
        return !this._isClosed;
    }

    public synchronized boolean close() {
        if (this._isClosed) {
            return true;
        }
        this._isClosed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (Db4oIOException db4oIOException) {
                // empty catch block
            }
        }
        this._synchronousMessageQueue.stop();
        this._asynchronousMessageQueue.stop();
        return true;
    }

    public void run() {
        this.messageLoop();
        this.close();
    }

    public void messageLoop() {
        while (this.isMessageDispatcherAlive()) {
            Msg message = null;
            try {
                message = Msg.readMessage(this, this.transaction(), this._socket);
            }
            catch (Db4oIOException exc) {
                if (DTrace.enabled) {
                    DTrace.CLIENT_MESSAGE_LOOP_EXCEPTION.log(exc.toString());
                }
                return;
            }
            if (message == null) continue;
            if (this.isClientSideMessage(message)) {
                this._asynchronousMessageQueue.add(message);
                continue;
            }
            this._synchronousMessageQueue.add(message);
        }
    }

    private boolean isClientSideMessage(Msg message) {
        return message instanceof ClientSideMessage;
    }

    public boolean write(Msg msg) {
        this._container.write(msg);
        return true;
    }

    public void setDispatcherName(String name) {
        this.setName("db4o client side message dispatcher for " + name);
    }

    public void startDispatcher() {
        this.start();
    }

    private Transaction transaction() {
        return this._container.transaction();
    }
}

