/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.convert;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.SystemData;
import com.db4o.internal.convert.Conversion;
import com.db4o.internal.convert.ConversionStage;
import com.db4o.internal.convert.conversions.CommonConversions;

public class Converter {
    public static final int VERSION = 7;
    private static Converter _converter;
    private Hashtable4 _conversions = new Hashtable4();

    private Converter() {
        CommonConversions.register(this);
    }

    public static boolean convert(ConversionStage stage) {
        if (!Converter.needsConversion(stage.systemData())) {
            return false;
        }
        if (_converter == null) {
            _converter = new Converter();
        }
        return _converter.runConversions(stage);
    }

    private static boolean needsConversion(SystemData systemData) {
        return systemData.converterVersion() < 7;
    }

    public void register(int idx, Conversion conversion) {
        if (this._conversions.get(idx) != null) {
            throw new IllegalStateException();
        }
        this._conversions.put(idx, (Object)conversion);
    }

    public boolean runConversions(ConversionStage stage) {
        SystemData systemData = stage.systemData();
        if (!Converter.needsConversion(systemData)) {
            return false;
        }
        for (int i = systemData.converterVersion(); i <= 7; ++i) {
            Conversion conversion = (Conversion)this._conversions.get(i);
            if (conversion == null) continue;
            stage.accept(conversion);
        }
        return true;
    }
}

