/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.Indexable4;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTreeNode;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.mapping.DefragmentServices;
import com.db4o.marshall.Context;

public class BTree
extends PersistentBase
implements TransactionParticipant {
    private static final byte BTREE_VERSION = 1;
    private static final int DEFRAGMENT_INCREMENT_OFFSET = 9;
    private final Indexable4 _keyHandler;
    private BTreeNode _root;
    private TreeIntObject _nodes;
    private int _size;
    private Visitor4 _removeListener;
    private Hashtable4 _sizesByTransaction;
    protected Queue4 _processing;
    private int _nodeSize;
    int _halfNodeSize;
    private final int _cacheHeight;

    public BTree(Transaction trans, int id, Indexable4 keyHandler) {
        this(trans, id, keyHandler, BTree.config(trans).bTreeNodeSize(), BTree.config(trans).bTreeCacheHeight());
    }

    public BTree(Transaction trans, int id, Indexable4 keyHandler, int treeNodeSize, int treeCacheHeight) {
        if (null == keyHandler) {
            throw new ArgumentNullException();
        }
        this._nodeSize = treeNodeSize;
        this._halfNodeSize = this._nodeSize / 2;
        this._nodeSize = this._halfNodeSize * 2;
        this._cacheHeight = treeCacheHeight;
        this._keyHandler = keyHandler;
        this._sizesByTransaction = new Hashtable4();
        if (id == 0) {
            this.setStateDirty();
            this._root = new BTreeNode(this, 0, true, 0, 0, 0);
            this._root.write(trans.systemTransaction());
            this.addNode(this._root);
            this.write(trans.systemTransaction());
        } else {
            this.setID(id);
            this.setStateDeactivated();
        }
    }

    public BTreeNode root() {
        return this._root;
    }

    public int nodeSize() {
        return this._nodeSize;
    }

    public void add(Transaction trans, Object key) {
        this.keyCantBeNull(key);
        PreparedComparison preparedComparison = this._keyHandler.prepareComparison(trans.context(), key);
        this.ensureDirty(trans);
        BTreeNode rootOrSplit = this._root.add(trans, preparedComparison, key);
        if (rootOrSplit != null && rootOrSplit != this._root) {
            this._root = new BTreeNode(trans, this._root, rootOrSplit);
            this._root.write(trans.systemTransaction());
            this.addNode(this._root);
        }
    }

    public void remove(Transaction trans, Object key) {
        this.keyCantBeNull(key);
        PreparedComparison preparedComparison = this.keyHandler().prepareComparison(trans.context(), key);
        Iterator4 pointers = this.search(trans, preparedComparison).pointers();
        if (!pointers.moveNext()) {
            return;
        }
        BTreePointer first = (BTreePointer)pointers.current();
        this.ensureDirty(trans);
        BTreeNode node = first.node();
        node.remove(trans, preparedComparison, key, first.index());
    }

    public BTreeRange search(Transaction trans, Object key) {
        this.keyCantBeNull(key);
        return this.search(trans, this.keyHandler().prepareComparison(trans.context(), key));
    }

    private BTreeRange search(Transaction trans, PreparedComparison preparedComparison) {
        this.ensureActive(trans);
        BTreeNodeSearchResult start = this.searchLeaf(trans, preparedComparison, SearchTarget.LOWEST);
        BTreeNodeSearchResult end = this.searchLeaf(trans, preparedComparison, SearchTarget.HIGHEST);
        return start.createIncludingRange(end);
    }

    private void keyCantBeNull(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
    }

    public Indexable4 keyHandler() {
        return this._keyHandler;
    }

    public BTreeNodeSearchResult searchLeaf(Transaction trans, Object key, SearchTarget target) {
        return this.searchLeaf(trans, this._keyHandler.prepareComparison(trans.context(), key), target);
    }

    public BTreeNodeSearchResult searchLeaf(Transaction trans, PreparedComparison preparedComparison, SearchTarget target) {
        this.ensureActive(trans);
        return this._root.searchLeaf(trans, preparedComparison, target);
    }

    public void commit(Transaction trans) {
        Transaction systemTransaction = trans.systemTransaction();
        Object sizeDiff = this._sizesByTransaction.get(trans);
        if (sizeDiff != null) {
            this._size += ((Integer)sizeDiff).intValue();
        }
        this._sizesByTransaction.remove(trans);
        if (this._nodes != null) {
            this.commitNodes(trans);
            this.writeAllNodes(systemTransaction);
        }
        this.setStateDirty();
        this.write(systemTransaction);
        this.purge();
    }

    public void commitNodes(Transaction trans) {
        if (this._nodes == null) {
            return;
        }
        this.processAllNodes();
        while (this._processing.hasNext()) {
            ((BTreeNode)this._processing.next()).commit(trans);
        }
        this._processing = null;
    }

    public void rollback(Transaction trans) {
        Transaction systemTransaction = trans.systemTransaction();
        this._sizesByTransaction.remove(trans);
        if (this._nodes == null) {
            return;
        }
        this.processAllNodes();
        while (this._processing.hasNext()) {
            ((BTreeNode)this._processing.next()).rollback(trans);
        }
        this._processing = null;
        this.writeAllNodes(systemTransaction);
        this.setStateDirty();
        this.write(systemTransaction);
        this.purge();
    }

    private void writeAllNodes(final Transaction systemTransaction) {
        if (this._nodes == null) {
            return;
        }
        this._nodes.traverse(new Visitor4(){

            public void visit(Object obj) {
                BTreeNode node = (BTreeNode)((TreeIntObject)obj).getObject();
                node.write(systemTransaction);
            }
        });
    }

    private void purge() {
        if (this._nodes == null) {
            return;
        }
        TreeIntObject temp = this._nodes;
        this._nodes = null;
        if (this._cacheHeight > 0) {
            this._root.markAsCached(this._cacheHeight);
        } else {
            this._root.holdChildrenAsIDs();
            this.addNode(this._root);
        }
        temp.traverse(new Visitor4(){

            public void visit(Object obj) {
                BTreeNode node = (BTreeNode)((TreeIntObject)obj).getObject();
                node.purge();
            }
        });
    }

    private void processAllNodes() {
        this._processing = new NonblockingQueue();
        this._nodes.traverse(new Visitor4(){

            public void visit(Object obj) {
                BTree.this._processing.add(((TreeIntObject)obj).getObject());
            }
        });
    }

    private void ensureActive(Transaction trans) {
        if (!this.isActive()) {
            this.read(trans.systemTransaction());
        }
    }

    private void ensureDirty(Transaction trans) {
        this.ensureActive(trans);
        if (this.canEnlistWithTransaction()) {
            ((LocalTransaction)trans).enlist(this);
        }
        this.setStateDirty();
    }

    protected boolean canEnlistWithTransaction() {
        return true;
    }

    public byte getIdentifier() {
        return 84;
    }

    public void setRemoveListener(Visitor4 vis) {
        this._removeListener = vis;
    }

    public int ownLength() {
        return 13;
    }

    BTreeNode produceNode(int id) {
        TreeIntObject addtio = new TreeIntObject(id);
        this._nodes = (TreeIntObject)Tree.add(this._nodes, addtio);
        TreeIntObject tio = (TreeIntObject)addtio.addedOrExisting();
        BTreeNode node = (BTreeNode)tio.getObject();
        if (node == null) {
            node = new BTreeNode(id, this);
            tio.setObject(node);
            this.addToProcessing(node);
        }
        return node;
    }

    void addNode(BTreeNode node) {
        this._nodes = (TreeIntObject)Tree.add(this._nodes, new TreeIntObject(node.getID(), node));
        this.addToProcessing(node);
    }

    void addToProcessing(BTreeNode node) {
        if (this._processing != null) {
            this._processing.add(node);
        }
    }

    void removeNode(BTreeNode node) {
        this._nodes = (TreeIntObject)this._nodes.removeLike(new TreeInt(node.getID()));
    }

    void notifyRemoveListener(Object obj) {
        if (this._removeListener != null) {
            this._removeListener.visit(obj);
        }
    }

    public void readThis(Transaction a_trans, ByteArrayBuffer a_reader) {
        a_reader.incrementOffset(1);
        this._size = a_reader.readInt();
        this._nodeSize = a_reader.readInt();
        this._halfNodeSize = this.nodeSize() / 2;
        this._root = this.produceNode(a_reader.readInt());
    }

    public void writeThis(Transaction trans, ByteArrayBuffer a_writer) {
        a_writer.writeByte((byte)1);
        a_writer.writeInt(this._size);
        a_writer.writeInt(this.nodeSize());
        a_writer.writeIDOf(trans, this._root);
    }

    public int size(Transaction trans) {
        this.ensureActive(trans);
        Object sizeDiff = this._sizesByTransaction.get(trans);
        if (sizeDiff != null) {
            return this._size + (Integer)sizeDiff;
        }
        return this._size;
    }

    public void traverseKeys(Transaction trans, Visitor4 visitor) {
        this.ensureActive(trans);
        if (this._root == null) {
            return;
        }
        this._root.traverseKeys(trans, visitor);
    }

    public void sizeChanged(Transaction trans, int changeBy) {
        Object sizeDiff = this._sizesByTransaction.get(trans);
        if (sizeDiff == null) {
            this._sizesByTransaction.put(trans, (Object)new Integer(changeBy));
            return;
        }
        this._sizesByTransaction.put(trans, (Object)new Integer((Integer)sizeDiff + changeBy));
    }

    public void dispose(Transaction transaction) {
    }

    public BTreePointer firstPointer(Transaction trans) {
        this.ensureActive(trans);
        if (null == this._root) {
            return null;
        }
        return this._root.firstPointer(trans);
    }

    public BTreePointer lastPointer(Transaction trans) {
        this.ensureActive(trans);
        if (null == this._root) {
            return null;
        }
        return this._root.lastPointer(trans);
    }

    public BTree debugLoadFully(Transaction trans) {
        this.ensureActive(trans);
        this._root.debugLoadFully(trans);
        return this;
    }

    private void traverseAllNodes(Transaction trans, Visitor4 command) {
        this.ensureActive(trans);
        this._root.traverseAllNodes(trans, command);
    }

    public void defragIndex(DefragmentContextImpl context) {
        context.incrementOffset(9);
        context.copyID();
    }

    public void defragIndexNode(DefragmentContextImpl context) {
        BTreeNode.defragIndex(context, this._keyHandler);
    }

    public void defragBTree(final DefragmentServices services) {
        DefragmentContextImpl.processCopy(services, this.getID(), new SlotCopyHandler(){

            public void processCopy(DefragmentContextImpl context) {
                BTree.this.defragIndex(context);
            }
        });
        services.traverseAllIndexSlots(this, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                DefragmentContextImpl.processCopy(services, id, new SlotCopyHandler(){

                    public void processCopy(DefragmentContextImpl context) {
                        BTree.this.defragIndexNode(context);
                    }
                });
            }
        });
    }

    public int compareKeys(Context context, Object key1, Object key2) {
        PreparedComparison preparedComparison = this._keyHandler.prepareComparison(context, key1);
        return preparedComparison.compareTo(key2);
    }

    private static Config4Impl config(Transaction trans) {
        if (null == trans) {
            throw new ArgumentNullException();
        }
        return trans.container().configImpl();
    }

    public void free(Transaction systemTrans) {
        this.freeAllNodeIds(systemTrans, this.allNodeIds(systemTrans));
        super.free(systemTrans);
    }

    private void freeAllNodeIds(Transaction systemTrans, Iterator4 allNodeIDs) {
        while (allNodeIDs.moveNext()) {
            int id = (Integer)allNodeIDs.current();
            systemTrans.slotFreePointerOnCommit(id);
        }
    }

    public Iterator4 allNodeIds(Transaction systemTrans) {
        final Collection4 allNodeIDs = new Collection4();
        this.traverseAllNodes(systemTrans, new Visitor4(){

            public void visit(Object node) {
                allNodeIDs.add(new Integer(((BTreeNode)node).getID()));
            }
        });
        return allNodeIDs.iterator();
    }

    public BTreeRange asRange(Transaction trans) {
        return new BTreeRangeSingle(trans, this, this.firstPointer(trans), null);
    }

    private void traverseAllNodes(final Visitor4 visitor) {
        if (this._nodes == null) {
            return;
        }
        this._nodes.traverse(new Visitor4(){

            public void visit(Object obj) {
                visitor.visit(((TreeIntObject)obj).getObject());
            }
        });
    }

    public String toString() {
        final StringBuffer sb = new StringBuffer();
        sb.append("BTree ");
        sb.append(this.getID());
        sb.append(" Active Nodes: \n");
        this.traverseAllNodes(new Visitor4(){

            public void visit(Object obj) {
                sb.append(obj);
                sb.append("\n");
            }
        });
        return sb.toString();
    }
}

