/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.StoredFieldImpl;
import com.db4o.internal.Transaction;

public class StoredClassImpl
implements StoredClass {
    private final Transaction _transaction;
    private final ClassMetadata _classMetadata;

    public StoredClassImpl(Transaction transaction, ClassMetadata classMetadata) {
        if (classMetadata == null) {
            throw new IllegalArgumentException();
        }
        this._transaction = transaction;
        this._classMetadata = classMetadata;
    }

    public long[] getIDs() {
        return this._classMetadata.getIDs(this._transaction);
    }

    public String getName() {
        return this._classMetadata.getName();
    }

    public StoredClass getParentStoredClass() {
        ClassMetadata parentClassMetadata = this._classMetadata.getAncestor();
        if (parentClassMetadata == null) {
            return null;
        }
        return new StoredClassImpl(this._transaction, parentClassMetadata);
    }

    public StoredField[] getStoredFields() {
        StoredField[] fieldMetadata = this._classMetadata.getStoredFields();
        StoredField[] storedFields = new StoredField[fieldMetadata.length];
        for (int i = 0; i < fieldMetadata.length; ++i) {
            storedFields[i] = new StoredFieldImpl(this._transaction, (FieldMetadata)fieldMetadata[i]);
        }
        return storedFields;
    }

    public boolean hasClassIndex() {
        return this._classMetadata.hasClassIndex();
    }

    public void rename(String newName) {
        this._classMetadata.rename(newName);
    }

    public StoredField storedField(String name, Object type) {
        FieldMetadata fieldMetadata = (FieldMetadata)this._classMetadata.storedField(name, type);
        if (fieldMetadata == null) {
            return null;
        }
        return new StoredFieldImpl(this._transaction, fieldMetadata);
    }

    public int hashCode() {
        return this._classMetadata.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this._classMetadata.equals(((StoredClassImpl)obj)._classMetadata);
    }

    public int instanceCount() {
        return this._classMetadata.instanceCount(this._transaction);
    }
}

