/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.Queue4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Transaction;

class PendingClassInits {
    private final Transaction _systemTransaction;
    private Collection4 _pending = new Collection4();
    private Queue4 _members = new NonblockingQueue();
    private Queue4 _statics = new NonblockingQueue();
    private Queue4 _writes = new NonblockingQueue();
    private Queue4 _inits = new NonblockingQueue();
    private boolean _running = false;

    PendingClassInits(Transaction systemTransaction) {
        this._systemTransaction = systemTransaction;
    }

    void process(ClassMetadata newYapClass) {
        if (this._pending.contains(newYapClass)) {
            return;
        }
        ClassMetadata ancestor = newYapClass.getAncestor();
        if (ancestor != null) {
            this.process(ancestor);
        }
        this._pending.add(newYapClass);
        this._members.add(newYapClass);
        if (this._running) {
            return;
        }
        this._running = true;
        this.checkInits();
        this._pending = new Collection4();
        this._running = false;
    }

    private void checkMembers() {
        while (this._members.hasNext()) {
            ClassMetadata classMetadata = (ClassMetadata)this._members.next();
            classMetadata.addMembers(this.stream());
            this._statics.add(classMetadata);
        }
    }

    private ObjectContainerBase stream() {
        return this._systemTransaction.container();
    }

    private void checkStatics() {
        this.checkMembers();
        while (this._statics.hasNext()) {
            ClassMetadata yc = (ClassMetadata)this._statics.next();
            yc.storeStaticFieldValues(this._systemTransaction, true);
            this._writes.add(yc);
            this.checkMembers();
        }
    }

    private void checkWrites() {
        this.checkStatics();
        while (this._writes.hasNext()) {
            ClassMetadata yc = (ClassMetadata)this._writes.next();
            yc.setStateDirty();
            yc.write(this._systemTransaction);
            this._inits.add(yc);
            this.checkStatics();
        }
    }

    private void checkInits() {
        this.checkWrites();
        while (this._inits.hasNext()) {
            ClassMetadata yc = (ClassMetadata)this._inits.next();
            yc.initConfigOnUp(this._systemTransaction);
            this.checkWrites();
        }
    }
}

