/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Closure4;

public class DynamicVariable {
    private final Class _expectedType;
    private ThreadSlot _values = null;

    public DynamicVariable() {
        this(null);
    }

    public DynamicVariable(Class expectedType) {
        this._expectedType = expectedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object value() {
        Thread current = Thread.currentThread();
        DynamicVariable dynamicVariable = this;
        synchronized (dynamicVariable) {
            ThreadSlot slot = this._values;
            while (null != slot) {
                if (slot.thread == current) {
                    return slot.value;
                }
                slot = slot.next;
            }
        }
        return this.defaultValue();
    }

    protected Object defaultValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object with(Object value, Closure4 block) {
        this.validate(value);
        ThreadSlot slot = this.pushValue(value);
        try {
            Object object = block.run();
            return object;
        }
        finally {
            this.popValue(slot);
        }
    }

    public void with(Object value, final Runnable block) {
        this.with(value, new Closure4(){

            public Object run() {
                block.run();
                return null;
            }
        });
    }

    private void validate(Object value) {
        if (value == null || this._expectedType == null) {
            return;
        }
        if (this._expectedType.isInstance(value)) {
            return;
        }
        throw new IllegalArgumentException("Expecting instance of '" + this._expectedType + "' but got '" + value + "'");
    }

    private synchronized void popValue(ThreadSlot slot) {
        if (slot == this._values) {
            this._values = this._values.next;
            return;
        }
        ThreadSlot previous = this._values;
        ThreadSlot current = this._values.next;
        while (current != null) {
            if (current == slot) {
                previous.next = current.next;
                return;
            }
            previous = current;
            current = current.next;
        }
    }

    private synchronized ThreadSlot pushValue(Object value) {
        ThreadSlot slot;
        this._values = slot = new ThreadSlot(value, this._values);
        return slot;
    }

    private static class ThreadSlot {
        public final Thread thread = Thread.currentThread();
        public final Object value;
        public ThreadSlot next;

        public ThreadSlot(Object value_, ThreadSlot next_) {
            this.value = value_;
            this.next = next_;
        }
    }
}

