/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.QuickSortable4;
import com.db4o.foundation.Stack4;

public class Algorithms4 {
    public static void qsort(QuickSortable4 sortable) {
        Stack4 stack = new Stack4();
        Algorithms4.addRange(stack, 0, sortable.size() - 1);
        Algorithms4.qsort(sortable, stack);
    }

    private static void qsort(QuickSortable4 sortable, Stack4 stack) {
        while (!stack.isEmpty()) {
            int to;
            Range range = (Range)stack.peek();
            stack.pop();
            int from = range._from;
            int pivot = to = range._to;
            int left = from;
            int right = to;
            while (left < right) {
                while (left < right && sortable.compare(left, pivot) < 0) {
                    ++left;
                }
                while (left < right && sortable.compare(right, pivot) >= 0) {
                    --right;
                }
                Algorithms4.swap(sortable, left, right);
            }
            Algorithms4.swap(sortable, to, right);
            Algorithms4.addRange(stack, from, right - 1);
            Algorithms4.addRange(stack, right + 1, to);
        }
    }

    private static void addRange(Stack4 stack, int from, int to) {
        if (to - from < 1) {
            return;
        }
        stack.push(new Range(from, to));
    }

    private static void swap(QuickSortable4 sortable, int left, int right) {
        if (left == right) {
            return;
        }
        sortable.swap(left, right);
    }

    private static class Range {
        int _from;
        int _to;

        public Range(int from, int to) {
            this._from = from;
            this._to = to;
        }
    }
}

