/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.defragment.DefragmentConfig;
import com.db4o.defragment.DefragmentInfo;
import com.db4o.defragment.DefragmentListener;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.FirstPassCommand;
import com.db4o.defragment.PassCommand;
import com.db4o.defragment.SecondPassCommand;
import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Visitor4;
import com.db4o.foundation.io.File4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.classindex.BTreeClassIndexStrategy;
import com.db4o.internal.mapping.IdSource;
import java.io.File;
import java.io.IOException;

public class Defragment {
    public static void defrag(String origPath) throws IOException {
        Defragment.defrag(new DefragmentConfig(origPath), new NullListener());
    }

    public static void defrag(String origPath, String backupPath) throws IOException {
        Defragment.defrag(new DefragmentConfig(origPath, backupPath), new NullListener());
    }

    public static void defrag(DefragmentConfig config) throws IOException {
        Defragment.defrag(config, new NullListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defrag(DefragmentConfig config, DefragmentListener listener) throws IOException {
        Defragment.ensureFileExists(config.origPath());
        File backupFile = new File(config.backupPath());
        if (backupFile.exists()) {
            if (!config.forceBackupDelete()) {
                throw new IOException("Could not use '" + config.backupPath() + "' as backup path - file exists.");
            }
            backupFile.delete();
        }
        File4.rename(config.origPath(), config.backupPath());
        if (config.fileNeedsUpgrade()) {
            Defragment.upgradeFile(config);
        }
        DefragmentServicesImpl context = new DefragmentServicesImpl(config, listener);
        int newClassCollectionID = 0;
        int targetIdentityID = 0;
        int targetUuidIndexID = 0;
        try {
            Defragment.firstPass(context, config);
            Defragment.secondPass(context, config);
            Defragment.defragUnindexed(context);
            newClassCollectionID = context.mappedID(context.sourceClassCollectionID());
            context.targetClassCollectionID(newClassCollectionID);
            int sourceIdentityID = context.databaseIdentityID(DefragmentServicesImpl.SOURCEDB);
            targetIdentityID = context.mappedID(sourceIdentityID, 0);
            targetUuidIndexID = context.mappedID(context.sourceUuidIndexID(), 0);
        }
        catch (CorruptionException exc) {
            exc.printStackTrace();
        }
        finally {
            context.close();
        }
        if (targetIdentityID > 0) {
            Defragment.setIdentity(config, targetIdentityID, targetUuidIndexID);
        } else {
            listener.notifyDefragmentInfo(new DefragmentInfo("No database identity found in original file."));
        }
    }

    private static void ensureFileExists(String origPath) throws IOException {
        File file = new File(origPath);
        if (!file.exists() || file.length() == 0L) {
            throw new IOException("Source database file '" + origPath + "' does not exist or is empty.");
        }
    }

    private static void upgradeFile(DefragmentConfig config) throws IOException {
        File4.copy(config.backupPath(), config.tempPath());
        Configuration db4oConfig = (Configuration)((Config4Impl)config.db4oConfig()).deepClone(null);
        db4oConfig.allowVersionUpdates(true);
        ObjectContainer db = Db4o.openFile(db4oConfig, config.tempPath());
        db.close();
    }

    private static void defragUnindexed(DefragmentServicesImpl services) {
        IdSource unindexedIDs = services.unindexedIDs();
        while (unindexedIDs.hasMoreIds()) {
            int origID = unindexedIDs.nextId();
            DefragmentContextImpl.processCopy(services, origID, new SlotCopyHandler(){

                public void processCopy(DefragmentContextImpl context) {
                    ClassMetadata.defragObject(context);
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIdentity(DefragmentConfig config, int targetIdentityID, int targetUuidIndexID) {
        LocalObjectContainer targetDB = (LocalObjectContainer)Db4o.openFile(config.clonedDb4oConfig(), config.origPath());
        try {
            Db4oDatabase identity = (Db4oDatabase)targetDB.getByID(targetIdentityID);
            targetDB.setIdentity(identity);
            targetDB.systemData().uuidIndexId(targetUuidIndexID);
        }
        finally {
            targetDB.close();
        }
    }

    private static void firstPass(DefragmentServicesImpl context, DefragmentConfig config) throws CorruptionException, IOException {
        Defragment.pass(context, config, new FirstPassCommand());
    }

    private static void secondPass(DefragmentServicesImpl context, DefragmentConfig config) throws CorruptionException, IOException {
        Defragment.pass(context, config, new SecondPassCommand(config.objectCommitFrequency()));
    }

    private static void pass(DefragmentServicesImpl context, DefragmentConfig config, PassCommand command) throws CorruptionException, IOException {
        command.processClassCollection(context);
        StoredClass[] classes = context.storedClasses(DefragmentServicesImpl.SOURCEDB);
        for (int classIdx = 0; classIdx < classes.length; ++classIdx) {
            ClassMetadata yapClass = (ClassMetadata)classes[classIdx];
            if (!config.storedClassFilter().accept(yapClass)) continue;
            Defragment.processYapClass(context, yapClass, command);
            command.flush(context);
            if (config.objectCommitFrequency() <= 0) continue;
            context.targetCommit();
        }
        BTree uuidIndex = context.sourceUuidIndex();
        if (uuidIndex != null) {
            command.processBTree(context, uuidIndex);
        }
        command.flush(context);
        context.targetCommit();
    }

    private static void processYapClass(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        Defragment.processClassIndex(context, curClass, command);
        if (!Defragment.parentHasIndex(curClass)) {
            Defragment.processObjectsForYapClass(context, curClass, command);
        }
        Defragment.processYapClassAndFieldIndices(context, curClass, command);
    }

    private static boolean parentHasIndex(ClassMetadata curClass) {
        for (ClassMetadata parentClass = curClass.getAncestor(); parentClass != null; parentClass = parentClass.getAncestor()) {
            if (!parentClass.hasClassIndex()) continue;
            return true;
        }
        return false;
    }

    private static void processObjectsForYapClass(final DefragmentServicesImpl context, final ClassMetadata curClass, final PassCommand command) {
        context.traverseAll(curClass, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                try {
                    command.processObjectSlot(context, curClass, id);
                }
                catch (CorruptionException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static void processYapClassAndFieldIndices(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        int sourceClassIndexID = 0;
        int targetClassIndexID = 0;
        if (curClass.hasClassIndex()) {
            sourceClassIndexID = curClass.index().id();
            targetClassIndexID = context.mappedID(sourceClassIndexID, -1);
        }
        command.processClass(context, curClass, curClass.getID(), targetClassIndexID);
    }

    private static void processClassIndex(DefragmentServicesImpl context, ClassMetadata curClass, PassCommand command) throws CorruptionException, IOException {
        if (curClass.hasClassIndex()) {
            BTreeClassIndexStrategy indexStrategy = (BTreeClassIndexStrategy)curClass.index();
            BTree btree = indexStrategy.btree();
            command.processBTree(context, btree);
        }
    }

    static class NullListener
    implements DefragmentListener {
        NullListener() {
        }

        public void notifyDefragmentInfo(DefragmentInfo info) {
        }
    }
}

