/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.util;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectServer;
import com.db4o.config.ObjectTranslator;
import com.db4o.config.TSerializable;
import java.io.File;

public class DbUtil {
    private static final String DB_FILE_SUFFIX = ".db4o.yap";
    private static final int PORT = 0;
    private static ObjectServer objectServer;
    private static final ThreadLocal dbThreadLocal;

    public static ObjectContainer getObjectContainer() {
        ObjectContainer objectContainer = (ObjectContainer)dbThreadLocal.get();
        if (objectContainer == null || objectContainer.ext().isClosed()) {
            objectContainer = DbUtil.getObjectServer().openClient();
            dbThreadLocal.set(objectContainer);
        }
        return objectContainer;
    }

    public static void closeDb() {
        ObjectContainer objectContainer = (ObjectContainer)dbThreadLocal.get();
        dbThreadLocal.set(null);
        if (objectContainer != null) {
            objectContainer.close();
        }
    }

    public static ObjectServer getObjectServer() {
        return DbUtil.getObjectServer(null);
    }

    public static synchronized ObjectServer getObjectServer(String string) {
        return DbUtil.getObjectServer(string, 0);
    }

    public static ObjectServer getObjectServer(String string, int n) {
        if (string == null) {
            string = "default";
        }
        if (objectServer == null) {
            objectServer = DbUtil.getObjectServerForFilename(string + DB_FILE_SUFFIX, n);
        }
        return objectServer;
    }

    public static void shutdown() {
        if (objectServer != null) {
            objectServer.close();
        }
    }

    public static ObjectServer getObjectServerForFilename(String string, int n) {
        File file = DbUtil.getDbDirectory();
        File file2 = new File(file, string);
        Db4o.configure().generateUUIDs(Integer.MAX_VALUE);
        Db4o.configure().generateVersionNumbers(Integer.MAX_VALUE);
        Db4o.configure().exceptionsOnNotStorable(true);
        Db4o.configure().objectClass((Object)"java.math.BigDecimal").translate((ObjectTranslator)new TSerializable());
        Db4o.configure().allowVersionUpdates(true);
        ObjectServer objectServer = Db4o.openServer((String)file2.getPath(), (int)n);
        return objectServer;
    }

    private static File getDbDirectory() {
        String string = System.getProperty("user.home") + "/db4o/data";
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    static {
        dbThreadLocal = new ThreadLocal();
    }
}

