/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.util;

import com.db4o.ObjectContainer;
import com.db4o.ext.StoredClass;
import com.db4o.ext.StoredField;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericVirtualField;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectHelper {
    public static List getUserStoredClasses(ObjectContainer objectContainer) {
        String[] stringArray = new String[]{"java.lang.", "java.util.", "java.math.", "com.db4o.", "j4o.lang.AssemblyNameHint"};
        ReflectClass[] reflectClassArray = objectContainer.ext().knownClasses();
        ArrayList<ReflectClass> arrayList = new ArrayList<ReflectClass>();
        for (int i = 0; i < reflectClassArray.length; ++i) {
            StoredClass storedClass;
            ReflectClass reflectClass = reflectClassArray[i];
            if (reflectClass.isArray() || reflectClass.isPrimitive()) continue;
            boolean bl = true;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!reflectClass.getName().startsWith(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl || (storedClass = objectContainer.ext().storedClass((Object)reflectClass.getName())) == null) continue;
            arrayList.add(reflectClass);
        }
        Collections.sort(arrayList, new Comparator(){
            private Collator comparator = Collator.getInstance();

            public int compare(Object object, Object object2) {
                ReflectClass reflectClass = (ReflectClass)object;
                ReflectClass reflectClass2 = (ReflectClass)object2;
                return this.comparator.compare(reflectClass.getName(), reflectClass2.getName());
            }
        });
        return arrayList;
    }

    public static ReflectField[] getDeclaredFieldsInHeirarchy(ReflectClass reflectClass) {
        List<ReflectField> list = ReflectHelper.getDeclaredFieldsListInHeirarchy(reflectClass);
        return list.toArray(new ReflectField[list.size()]);
    }

    private static List<ReflectField> getDeclaredFieldsListInHeirarchy(ReflectClass reflectClass) {
        if (reflectClass == null) {
            return null;
        }
        List<ReflectField> list = ReflectHelper.getDeclaredFieldsList(reflectClass);
        ReflectClass reflectClass2 = reflectClass.getSuperclass();
        if (reflectClass2 != null) {
            list.addAll(ReflectHelper.getDeclaredFieldsListInHeirarchy(reflectClass2));
        }
        return list;
    }

    public static List<ReflectField> getDeclaredFieldsList(ReflectClass reflectClass) {
        ArrayList<ReflectField> arrayList = new ArrayList<ReflectField>();
        ReflectField[] reflectFieldArray = reflectClass.getDeclaredFields();
        for (int i = 0; i < reflectFieldArray.length; ++i) {
            ReflectField reflectField = reflectFieldArray[i];
            if (reflectField instanceof GenericVirtualField) continue;
            arrayList.add(reflectField);
        }
        return arrayList;
    }

    public static StoredField[] getDeclaredFieldsInHeirarchy(StoredClass storedClass) {
        List list = ReflectHelper.getDeclaredFieldsListInHeirarchy(storedClass);
        return list.toArray(new StoredField[list.size()]);
    }

    private static List getDeclaredFieldsListInHeirarchy(StoredClass storedClass) {
        if (storedClass == null) {
            return null;
        }
        List<StoredField> list = ReflectHelper.getDeclaredFieldsList(storedClass);
        StoredClass storedClass2 = storedClass.getParentStoredClass();
        if (storedClass2 != null) {
            list.addAll(ReflectHelper.getDeclaredFieldsListInHeirarchy(storedClass2));
        }
        return list;
    }

    public static List<StoredField> getDeclaredFieldsList(StoredClass storedClass) {
        ArrayList<StoredField> arrayList = new ArrayList<StoredField>();
        StoredField[] storedFieldArray = storedClass.getStoredFields();
        for (int i = 0; i < storedFieldArray.length; ++i) {
            StoredField storedField = storedFieldArray[i];
            if (storedField instanceof GenericVirtualField) continue;
            arrayList.add(storedField);
        }
        return arrayList;
    }

    public static ReflectField[] getDeclaredFields(ReflectClass reflectClass) {
        List<ReflectField> list = ReflectHelper.getDeclaredFieldsList(reflectClass);
        return list.toArray(new ReflectField[list.size()]);
    }

    public static ReflectField getDeclaredFieldInHeirarchy(ReflectClass reflectClass, String string) {
        ReflectClass reflectClass2;
        ReflectField reflectField = reflectClass.getDeclaredField(string);
        if (reflectField == null && (reflectClass2 = reflectClass.getSuperclass()) != null) {
            return ReflectHelper.getDeclaredFieldInHeirarchy(reflectClass2, string);
        }
        return reflectField;
    }
}

