/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.SqlStatement;
import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.FromBuilder;
import com.spaceprogram.db4o.sql.parser.OrderByBuilder;
import com.spaceprogram.db4o.sql.parser.SelectBuilder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.WhereBuilder;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlParser {
    private static String REGEX_QUOTED_STRING = "'[^']*'";
    private Builder[] builders = new Builder[]{new SelectBuilder(), new FromBuilder(), new WhereBuilder(), new OrderByBuilder()};
    private String query;
    private List<String> quotedStrings = new ArrayList<String>();

    public static SqlStatement parse(String string) throws SqlParseException {
        SqlParser sqlParser = new SqlParser();
        sqlParser.setQuery(string);
        return sqlParser.doParse();
    }

    private SqlStatement doParse() throws SqlParseException {
        this.query = this.replaceQuotedStrings(this.query);
        String[] stringArray = this.query.trim().split("\\s+");
        if (stringArray.length < 2) {
            throw new SqlParseException("Invalid query.");
        }
        SqlQuery sqlQuery = new SqlQuery();
        this.buildQuery(stringArray, sqlQuery);
        if (sqlQuery.getFrom() == null) {
            throw new SqlParseException("No FROM part!");
        }
        return sqlQuery;
    }

    private String replaceQuotedStrings(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        Pattern pattern = Pattern.compile(REGEX_QUOTED_STRING);
        Matcher matcher = pattern.matcher(stringBuffer);
        boolean bl = false;
        int n = 0;
        while (matcher.find()) {
            this.quotedStrings.add(matcher.group());
            stringBuffer.replace(matcher.start(), matcher.end(), "{" + n + "}");
            matcher.reset();
            bl = true;
            ++n;
        }
        if (!bl) {
            // empty if block
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private void buildQuery(String[] stringArray, SqlQuery sqlQuery) throws SqlParseException {
        Builder builder = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            Builder builder2 = this.getBuilder(string);
            if (builder2 != null) {
                if (builder != null) {
                    builder.build(sqlQuery, arrayList, this.quotedStrings);
                }
                builder = builder2;
                arrayList.clear();
                continue;
            }
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            if (builder != null) {
                builder.build(sqlQuery, arrayList, this.quotedStrings);
            } else {
                throw new SqlParseException("Invalid Query. No FROM part.");
            }
        }
    }

    private Builder getBuilder(String string) {
        for (Builder builder : this.builders) {
            if (!string.equalsIgnoreCase(builder.getKeyword())) continue;
            return builder;
        }
        return null;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public static String replaceQuotedValue(List<String> list, String string) {
        if (string.startsWith("{") && string.endsWith("}")) {
            int n = Integer.parseInt(string.substring(1, string.length() - 1));
            return list.get(n);
        }
        return string;
    }

    public static String stripQuotes(String string) {
        return string;
    }

    public static List<String> separateCommas(List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.equals(",")) {
                if (!bl) continue;
                arrayList.add(",");
            }
            String[] stringArray = string.split(",");
            int n = 0;
            for (String string2 : stringArray) {
                if (n > 0 && bl) {
                    arrayList.add(",");
                }
                arrayList.add(string2);
                ++n;
            }
        }
        return arrayList;
    }
}

