/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.parser;

import com.spaceprogram.db4o.sql.parser.Builder;
import com.spaceprogram.db4o.sql.parser.SqlParseException;
import com.spaceprogram.db4o.sql.parser.SqlParser;
import com.spaceprogram.db4o.sql.query.OrderBy;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderByBuilder
implements Builder {
    static final String keyword = "ORDER";

    @Override
    public String getKeyword() {
        return keyword;
    }

    @Override
    public void build(SqlQuery sqlQuery, List<String> list, List<String> list2) throws SqlParseException {
        OrderBy orderBy = new OrderBy();
        List<String> list3 = SqlParser.separateCommas(list.subList(1, list.size()), false);
        int n = 0;
        OrderBy.Field field = new OrderBy.Field();
        for (int i = 0; i < list3.size(); ++i) {
            String string = list3.get(i);
            if (string.equals(",")) {
                n = 0;
                orderBy.addField(field);
                field = new OrderBy.Field();
            }
            if (n > 1) {
                throw new SqlParseException("Order by clause invalid, too many parts: " + string);
            }
            if (n == 0) {
                field.setName(string);
            } else if (n == 1) {
                if (string.equalsIgnoreCase("ASC")) {
                    field.orderAscending();
                } else if (string.equalsIgnoreCase("DESC")) {
                    field.orderDescending();
                }
            }
            ++n;
        }
        if (n == 0) {
            throw new SqlParseException("Invalid ORDER BY clause.");
        }
        orderBy.addField(field);
        sqlQuery.setOrderBy(orderBy);
    }
}

