/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.ant;

import com.db4o.instrumentation.ant.AntClassEditFactory;
import com.db4o.instrumentation.ant.AntFileSetPathRoot;
import com.db4o.instrumentation.classfilter.CompositeOrClassFilter;
import com.db4o.instrumentation.classfilter.JarFileClassFilter;
import com.db4o.instrumentation.core.BloatClassEdit;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.core.CompositeBloatClassEdit;
import com.db4o.instrumentation.core.NullClassEdit;
import com.db4o.instrumentation.main.Db4oFileInstrumentor;
import com.db4o.instrumentation.main.Db4oJarEnhancer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

public class Db4oFileEnhancerAntTask
extends Task {
    private final List _sources = new ArrayList();
    private String _targetDir;
    private final List _classPath = new ArrayList();
    private final List _editFactories = new ArrayList();
    private final List _jars = new ArrayList();
    private String _jarTargetDir;

    public void add(AntClassEditFactory editFactory) {
        this._editFactories.add(editFactory);
    }

    public void addSources(FileSet fileSet) {
        this._sources.add(fileSet);
    }

    public void addJars(FileSet fileSet) {
        this._jars.add(fileSet);
    }

    public void setClassTargetDir(String targetDir) {
        this._targetDir = targetDir;
    }

    public void setJarTargetdir(String targetDir) {
        this._jarTargetDir = targetDir;
    }

    public void addClasspath(Path path) {
        this._classPath.add(path);
    }

    public void execute() {
        try {
            FileSet[] sourceArr = this._sources.toArray(new FileSet[this._sources.size()]);
            AntFileSetPathRoot root = new AntFileSetPathRoot(sourceArr);
            ClassFilter filter = this.collectClassFilters(root);
            BloatClassEdit clazzEdit = this.collectClassEdits(filter);
            String[] classPath = this.collectClassPath();
            this.enhanceClassFiles(root, clazzEdit, classPath);
            this.enhanceJars(clazzEdit, classPath);
        }
        catch (Exception exc) {
            throw new BuildException((Throwable)exc);
        }
    }

    private String[] collectClassPath() throws Exception {
        final ArrayList<String> paths = new ArrayList<String>();
        Iterator pathIter = this._classPath.iterator();
        while (pathIter.hasNext()) {
            Path path = (Path)pathIter.next();
            String[] curPaths = path.list();
            for (int curPathIdx = 0; curPathIdx < curPaths.length; ++curPathIdx) {
                paths.add(curPaths[curPathIdx]);
            }
        }
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws Exception {
                paths.add(resource.getFile().getCanonicalPath());
            }
        });
        Iterator fileSetIter = this._sources.iterator();
        while (fileSetIter.hasNext()) {
            FileSet fileSet = (FileSet)fileSetIter.next();
            paths.add(fileSet.getDir().getCanonicalPath());
        }
        return paths.toArray(new String[paths.size()]);
    }

    private void enhanceClassFiles(AntFileSetPathRoot root, BloatClassEdit clazzEdit, String[] classPath) throws Exception {
        new Db4oFileInstrumentor(clazzEdit).enhance(root, this._targetDir, classPath);
    }

    private void enhanceJars(BloatClassEdit clazzEdit, final String[] classPath) throws Exception {
        final Db4oJarEnhancer jarEnhancer = new Db4oJarEnhancer(clazzEdit);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws Exception {
                File targetJarFile = new File(Db4oFileEnhancerAntTask.this._jarTargetDir, resource.getFile().getName());
                jarEnhancer.enhance(resource.getFile(), targetJarFile, classPath);
            }
        });
    }

    private ClassFilter collectClassFilters(AntFileSetPathRoot root) throws Exception {
        final ArrayList<AntFileSetPathRoot> filters = new ArrayList<AntFileSetPathRoot>();
        filters.add(root);
        this.forEachResource(this._jars, new FileResourceBlock(){

            public void process(FileResource resource) throws IOException {
                JarFile jarFile = new JarFile(resource.getFile());
                filters.add(new JarFileClassFilter(jarFile));
            }
        });
        CompositeOrClassFilter filter = new CompositeOrClassFilter(filters.toArray(new ClassFilter[filters.size()]));
        return filter;
    }

    private void forEachResource(List fileSets, FileResourceBlock collectFiltersBlock) throws Exception {
        Iterator fileSetIter = fileSets.iterator();
        while (fileSetIter.hasNext()) {
            FileSet fileSet = (FileSet)fileSetIter.next();
            Iterator resourceIter = fileSet.iterator();
            while (resourceIter.hasNext()) {
                FileResource fileResource = (FileResource)resourceIter.next();
                collectFiltersBlock.process(fileResource);
            }
        }
    }

    private BloatClassEdit collectClassEdits(ClassFilter classFilter) {
        BloatClassEdit clazzEdit = null;
        switch (this._editFactories.size()) {
            case 0: {
                clazzEdit = new NullClassEdit();
                break;
            }
            case 1: {
                clazzEdit = ((AntClassEditFactory)this._editFactories.get(0)).createEdit(classFilter);
                break;
            }
            default: {
                ArrayList<BloatClassEdit> classEdits = new ArrayList<BloatClassEdit>(this._editFactories.size());
                Iterator factoryIter = this._editFactories.iterator();
                while (factoryIter.hasNext()) {
                    AntClassEditFactory curFactory = (AntClassEditFactory)factoryIter.next();
                    classEdits.add(curFactory.createEdit(classFilter));
                }
                clazzEdit = new CompositeBloatClassEdit(classEdits.toArray(new BloatClassEdit[classEdits.size()]), true);
            }
        }
        return clazzEdit;
    }

    private static interface FileResourceBlock {
        public void process(FileResource var1) throws Exception;
    }
}

