/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.query.processor;

import com.db4o.ObjectSet;
import com.db4o.config.QueryEvaluationMode;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.CompositeIterator4;
import com.db4o.foundation.Function4;
import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.MappingIterator;
import com.db4o.foundation.NoDuplicatesQueue;
import com.db4o.foundation.NonblockingQueue;
import com.db4o.foundation.ObjectByRef;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.IDGenerator;
import com.db4o.internal.LocalTransaction;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.TreeInt;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.callbacks.Callbacks;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.query.ObjectSetFacade;
import com.db4o.internal.query.processor.QCandidate;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConClass;
import com.db4o.internal.query.processor.QConEvaluation;
import com.db4o.internal.query.processor.QConJoin;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QConPath;
import com.db4o.internal.query.processor.QConUnconditional;
import com.db4o.internal.query.processor.QConstraints;
import com.db4o.internal.query.processor.QQuery;
import com.db4o.internal.query.result.IdListQueryResult;
import com.db4o.internal.query.result.QueryResult;
import com.db4o.query.Constraint;
import com.db4o.query.Constraints;
import com.db4o.query.Query;
import com.db4o.query.QueryComparator;
import com.db4o.reflect.ReflectClass;
import com.db4o.types.Unversioned;

public abstract class QQueryBase
implements Unversioned {
    private static final transient IDGenerator i_orderingGenerator = new IDGenerator();
    transient Transaction _trans;
    public Collection4 i_constraints = new Collection4();
    public QQuery i_parent;
    public String i_field;
    private transient QueryEvaluationMode _evaluationMode;
    public int _evaluationModeAsInt;
    public QueryComparator _comparator;
    private final transient QQuery _this = QQueryBase.cast(this);

    protected QQueryBase() {
    }

    protected QQueryBase(Transaction a_trans, QQuery a_parent, String a_field) {
        this._trans = a_trans;
        this.i_parent = a_parent;
        this.i_field = a_field;
    }

    void addConstraint(QCon a_constraint) {
        this.i_constraints.add(a_constraint);
    }

    private void addConstraint(Collection4 col, Object obj) {
        if (this.attachToExistingConstraints(col, obj, true)) {
            return;
        }
        if (this.attachToExistingConstraints(col, obj, false)) {
            return;
        }
        QConObject newConstraint = new QConObject(this._trans, null, null, obj);
        this.addConstraint(newConstraint);
        col.add(newConstraint);
    }

    private boolean attachToExistingConstraints(Collection4 col, Object obj, boolean onlyForPaths) {
        boolean found = false;
        Iterator4 j = this.iterateConstraints();
        while (j.moveNext()) {
            QCon newConstraint;
            QCon existingConstraint = (QCon)j.current();
            boolean[] removeExisting = new boolean[]{false};
            if (onlyForPaths && !(existingConstraint instanceof QConPath) || (newConstraint = existingConstraint.shareParent(obj, removeExisting)) == null) continue;
            this.addConstraint(newConstraint);
            col.add(newConstraint);
            if (removeExisting[0]) {
                this.removeConstraint(existingConstraint);
            }
            found = true;
            if (onlyForPaths) continue;
            return true;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraint constrain(Object example) {
        Object object = this.streamLock();
        synchronized (object) {
            example = Platform4.getClassForType(example);
            ReflectClass claxx = this.reflectClassForClass(example);
            if (claxx != null) {
                return this.addClassConstraint(claxx);
            }
            QConEvaluation eval = Platform4.evaluationCreate(this._trans, example);
            if (eval != null) {
                return this.addEvaluationToAllConstraints(eval);
            }
            Collection4 constraints = new Collection4();
            this.addConstraint(constraints, example);
            return this.toConstraint(constraints);
        }
    }

    private Constraint addEvaluationToAllConstraints(QConEvaluation eval) {
        if (this.i_constraints.size() == 0) {
            this._trans.container().classCollection().iterateTopLevelClasses(new Visitor4(){

                public void visit(Object obj) {
                    ClassMetadata classMetadata = (ClassMetadata)obj;
                    QConClass qcc = new QConClass(QQueryBase.this._trans, classMetadata.classReflector());
                    QQueryBase.this.addConstraint(qcc);
                    QQueryBase.this.toConstraint(QQueryBase.this.i_constraints).or(qcc);
                }
            });
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).addConstraint(eval);
        }
        return null;
    }

    private Constraint addClassConstraint(ReflectClass claxx) {
        if (claxx.equals(this.stream()._handlers.ICLASS_OBJECT)) {
            return null;
        }
        Collection4 col = new Collection4();
        if (claxx.isInterface()) {
            return this.addInterfaceConstraint(claxx);
        }
        Iterator4 constraintsIterator = this.iterateConstraints();
        while (constraintsIterator.moveNext()) {
            QConObject existingConstraint = (QConObject)constraintsIterator.current();
            boolean[] removeExisting = new boolean[]{false};
            QConClass newConstraint = ((QCon)existingConstraint).shareParentForClass(claxx, removeExisting);
            if (newConstraint == null) continue;
            this.addConstraint(newConstraint);
            col.add(newConstraint);
            if (!removeExisting[0]) continue;
            this.removeConstraint(existingConstraint);
        }
        if (col.size() == 0) {
            QConClass qcc = new QConClass(this._trans, claxx);
            this.addConstraint(qcc);
            return qcc;
        }
        return this.toConstraint(col);
    }

    private Constraint addInterfaceConstraint(ReflectClass claxx) {
        Collection4 classes = this.stream().classCollection().forInterface(claxx);
        if (classes.size() == 0) {
            QConClass qcc = new QConClass(this._trans, null, null, claxx);
            this.addConstraint(qcc);
            return qcc;
        }
        Iterator4 i = classes.iterator();
        Constraint constr = null;
        while (i.moveNext()) {
            ClassMetadata yapClass = (ClassMetadata)i.current();
            ReflectClass yapClassClaxx = yapClass.classReflector();
            if (yapClassClaxx == null || yapClassClaxx.isInterface()) continue;
            if (constr == null) {
                constr = this.constrain(yapClassClaxx);
                continue;
            }
            constr = constr.or(this.constrain(yapClass.classReflector()));
        }
        return constr;
    }

    private ReflectClass reflectClassForClass(Object example) {
        if (example instanceof ReflectClass) {
            return (ReflectClass)example;
        }
        if (example instanceof Class) {
            return this._trans.reflector().forClass((Class)example);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Constraints constraints() {
        Object object = this.streamLock();
        synchronized (object) {
            Object[] constraints = new Constraint[this.i_constraints.size()];
            this.i_constraints.toArray(constraints);
            return new QConstraints(this._trans, (Constraint[])constraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query descend(String a_field) {
        Object object = this.streamLock();
        synchronized (object) {
            QQuery query = new QQuery(this._trans, this._this, a_field);
            IntByRef run = new IntByRef(1);
            if (!this.descend1(query, a_field, run) && run.value == 1) {
                run.value = 2;
                if (!this.descend1(query, a_field, run)) {
                    new QConUnconditional(this._trans, false).attach(query, a_field);
                }
            }
            return query;
        }
    }

    private boolean descend1(QQuery query, String a_field, IntByRef run) {
        if (run.value == 2 || this.i_constraints.size() == 0) {
            run.value = 0;
            final BooleanByRef anyClassCollected = new BooleanByRef(false);
            this.stream().classCollection().attachQueryNode(a_field, new Visitor4(){

                public void visit(Object obj) {
                    Object[] pair = (Object[])obj;
                    ClassMetadata parentYc = (ClassMetadata)pair[0];
                    FieldMetadata yf = (FieldMetadata)pair[1];
                    ClassMetadata childYc = yf.handlerClassMetadata(QQueryBase.this.stream());
                    boolean take = true;
                    if (childYc instanceof UntypedFieldHandler) {
                        if (anyClassCollected.value) {
                            take = false;
                        } else {
                            anyClassCollected.value = true;
                        }
                    }
                    if (take) {
                        QConClass qcc = new QConClass(QQueryBase.this._trans, null, yf.qField(QQueryBase.this._trans), parentYc.classReflector());
                        QQueryBase.this.addConstraint(qcc);
                        QQueryBase.this.toConstraint(QQueryBase.this.i_constraints).or(qcc);
                    }
                }
            });
        }
        this.checkConstraintsEvaluationMode();
        BooleanByRef foundClass = new BooleanByRef(false);
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            if (!((QCon)i.current()).attach(query, a_field)) continue;
            foundClass.value = true;
        }
        return foundClass.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet execute() {
        Object object = this.streamLock();
        synchronized (object) {
            Callbacks callbacks = this.stream().callbacks();
            callbacks.queryOnStarted(this._trans, QQueryBase.cast(this));
            QueryResult qresult = this.getQueryResult();
            callbacks.queryOnFinished(this._trans, QQueryBase.cast(this));
            return new ObjectSetFacade(qresult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getQueryResult() {
        Object object = this.streamLock();
        synchronized (object) {
            if (this.i_constraints.size() == 0) {
                return this.stream().queryAllObjects(this._trans);
            }
            QueryResult result = this.classOnlyQuery();
            if (result != null) {
                return result;
            }
            this.optimizeJoins();
            return this.stream().executeQuery(this._this);
        }
    }

    protected ObjectContainerBase stream() {
        return this._trans.container();
    }

    private QueryResult classOnlyQuery() {
        if (this.i_constraints.size() != 1 || this._comparator != null) {
            return null;
        }
        Constraint constr = this.singleConstraint();
        if (constr.getClass() != QConClass.class) {
            return null;
        }
        QConClass clazzconstr = (QConClass)constr;
        ClassMetadata clazz = clazzconstr.i_yapClass;
        if (clazz == null) {
            return null;
        }
        if (clazzconstr.hasChildren() || clazz.isArray()) {
            return null;
        }
        QueryResult queryResult = this.stream().classOnlyQuery(this._trans, clazz);
        if (queryResult == null) {
            return null;
        }
        this.sort(queryResult);
        return queryResult;
    }

    private Constraint singleConstraint() {
        return (Constraint)this.i_constraints.singleElement();
    }

    public Iterator4 executeSnapshot() {
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        Collection4 executionPath = this.executionPath(r);
        Iterator4Impl candidatesIterator = new Iterator4Impl(r.candidateCollection);
        Collection4 snapshots = new Collection4();
        while (candidatesIterator.moveNext()) {
            QCandidates candidates = (QCandidates)candidatesIterator.current();
            snapshots.add(candidates.executeSnapshot(executionPath));
        }
        Iterator4 snapshotsIterator = snapshots.iterator();
        CompositeIterator4 resultingIDs = new CompositeIterator4(snapshotsIterator);
        if (!r.checkDuplicates) {
            return resultingIDs;
        }
        return this.checkDuplicates(resultingIDs);
    }

    public Iterator4 executeLazy() {
        this.checkConstraintsEvaluationMode();
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        final Collection4 executionPath = this.executionPath(r);
        Iterator4Impl candidateCollection = new Iterator4Impl(r.candidateCollection);
        MappingIterator executeCandidates = new MappingIterator(candidateCollection){

            protected Object map(Object current) {
                return ((QCandidates)current).executeLazy(executionPath);
            }
        };
        CompositeIterator4 resultingIDs = new CompositeIterator4(executeCandidates);
        if (!r.checkDuplicates) {
            return resultingIDs;
        }
        return this.checkDuplicates(resultingIDs);
    }

    private Iterator4 checkDuplicates(CompositeIterator4 executeAllCandidates) {
        return Iterators.filter(executeAllCandidates, new Predicate4(){
            private TreeInt ids = new TreeInt(0);

            public boolean match(Object current) {
                int id = (Integer)current;
                if (this.ids.find(id) != null) {
                    return false;
                }
                this.ids = (TreeInt)this.ids.add(new TreeInt(id));
                return true;
            }
        });
    }

    private Collection4 executionPath(CreateCandidateCollectionResult r) {
        return r.topLevel ? null : this.fieldPathFromTop();
    }

    public void checkConstraintsEvaluationMode() {
        Iterator4 constraints = this.iterateConstraints();
        while (constraints.moveNext()) {
            ((QConObject)constraints.current()).setEvaluationMode();
        }
    }

    public void executeLocal(final IdListQueryResult result) {
        this.checkConstraintsEvaluationMode();
        CreateCandidateCollectionResult r = this.createCandidateCollection();
        boolean checkDuplicates = r.checkDuplicates;
        boolean topLevel = r.topLevel;
        List4 candidateCollection = r.candidateCollection;
        if (candidateCollection != null) {
            final Collection4 executionPath = topLevel ? null : this.fieldPathFromTop();
            Iterator4Impl i = new Iterator4Impl(candidateCollection);
            while (i.moveNext()) {
                ((QCandidates)i.current()).execute();
            }
            if (candidateCollection._next != null) {
                checkDuplicates = true;
            }
            if (checkDuplicates) {
                result.checkDuplicates();
            }
            final ObjectContainerBase stream = this.stream();
            i = new Iterator4Impl(candidateCollection);
            while (i.moveNext()) {
                QCandidates candidates = (QCandidates)i.current();
                if (topLevel) {
                    candidates.traverse(result);
                    continue;
                }
                candidates.traverse(new Visitor4(){

                    public void visit(Object a_object) {
                        QCandidate candidate = (QCandidate)a_object;
                        if (candidate.include()) {
                            TreeInt ids = new TreeInt(candidate._key);
                            final ObjectByRef idsNew = new ObjectByRef(null);
                            Iterator4 itPath = executionPath.iterator();
                            while (itPath.moveNext()) {
                                idsNew.value = null;
                                final String fieldName = (String)itPath.current();
                                if (ids != null) {
                                    ids.traverse(new Visitor4(){

                                        public void visit(Object treeInt) {
                                            int id = ((TreeInt)treeInt)._key;
                                            StatefulBuffer reader = stream.readWriterByID(QQueryBase.this._trans, id);
                                            if (reader != null) {
                                                ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)reader);
                                                CollectIdContext context = new CollectIdContext(QQueryBase.this._trans, oh, reader);
                                                oh.classMetadata().collectIDs(context, fieldName);
                                                idsNew.value = context.ids();
                                            }
                                        }
                                    });
                                }
                                ids = (TreeInt)idsNew.value;
                            }
                            if (ids != null) {
                                ids.traverse(new Visitor4(){

                                    public void visit(Object treeInt) {
                                        result.addKeyCheckDuplicates(((TreeInt)treeInt)._key);
                                    }
                                });
                            }
                        }
                    }
                });
            }
        }
        this.sort(result);
    }

    private Collection4 fieldPathFromTop() {
        QQueryBase q = this;
        Collection4 fieldPath = new Collection4();
        while (q.i_parent != null) {
            fieldPath.prepend(q.i_field);
            q = q.i_parent;
        }
        return fieldPath;
    }

    private void logConstraints() {
    }

    public CreateCandidateCollectionResult createCandidateCollection() {
        List4 candidatesList = this.createQCandidatesList();
        boolean checkDuplicates = false;
        boolean topLevel = true;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ClassMetadata classMetadata;
            QCon constraint;
            QCon old = constraint = (QCon)i.current();
            if ((constraint = constraint.getRoot()) != old) {
                checkDuplicates = true;
                topLevel = false;
            }
            if ((classMetadata = constraint.getYapClass()) == null) break;
            this.addConstraintToCandidatesList(candidatesList, constraint);
        }
        return new CreateCandidateCollectionResult(candidatesList, checkDuplicates, topLevel);
    }

    private void addConstraintToCandidatesList(List4 candidatesList, QCon qcon) {
        if (candidatesList == null) {
            return;
        }
        Iterator4Impl j = new Iterator4Impl(candidatesList);
        while (j.moveNext()) {
            QCandidates candidates = (QCandidates)j.current();
            candidates.addConstraint(qcon);
        }
    }

    private List4 createQCandidatesList() {
        List4 candidatesList = null;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon constraint = (QCon)i.current();
            ClassMetadata classMetadata = (constraint = constraint.getRoot()).getYapClass();
            if (classMetadata == null || this.constraintCanBeAddedToExisting(candidatesList, constraint)) continue;
            QCandidates candidates = new QCandidates((LocalTransaction)this._trans, classMetadata, null);
            candidatesList = new List4(candidatesList, candidates);
        }
        return candidatesList;
    }

    private boolean constraintCanBeAddedToExisting(List4 candidatesList, QCon constraint) {
        Iterator4Impl j = new Iterator4Impl(candidatesList);
        while (j.moveNext()) {
            QCandidates candidates = (QCandidates)j.current();
            if (!candidates.fitsIntoExistingConstraintHierarchy(constraint)) continue;
            return true;
        }
        return false;
    }

    public final Transaction getTransaction() {
        return this._trans;
    }

    public Iterator4 iterateConstraints() {
        return new Collection4(this.i_constraints).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query orderAscending() {
        Object object = this.streamLock();
        synchronized (object) {
            this.setOrdering(i_orderingGenerator.next());
            return this._this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query orderDescending() {
        Object object = this.streamLock();
        synchronized (object) {
            this.setOrdering(-i_orderingGenerator.next());
            return this._this;
        }
    }

    private void setOrdering(int ordering) {
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).setOrdering(ordering);
        }
    }

    public void marshall() {
        this.checkConstraintsEvaluationMode();
        this._evaluationModeAsInt = this._evaluationMode.asInt();
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).getRoot().marshall();
        }
    }

    public void unmarshall(Transaction a_trans) {
        this._evaluationMode = QueryEvaluationMode.fromInt(this._evaluationModeAsInt);
        this._trans = a_trans;
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            ((QCon)i.current()).unmarshall(a_trans);
        }
    }

    void removeConstraint(QCon a_constraint) {
        this.i_constraints.remove(a_constraint);
    }

    Constraint toConstraint(Collection4 constraints) {
        if (constraints.size() == 1) {
            return (Constraint)constraints.singleElement();
        }
        if (constraints.size() > 0) {
            Object[] constraintArray = new Constraint[constraints.size()];
            constraints.toArray(constraintArray);
            return new QConstraints(this._trans, (Constraint[])constraintArray);
        }
        return null;
    }

    protected Object streamLock() {
        return this.stream()._lock;
    }

    public Query sortBy(QueryComparator comparator) {
        this._comparator = comparator;
        return this._this;
    }

    private void sort(QueryResult result) {
        if (this._comparator != null) {
            result.sort(this._comparator);
        }
    }

    private static QQuery cast(QQueryBase obj) {
        return (QQuery)obj;
    }

    public boolean requiresSort() {
        if (this._comparator != null) {
            return true;
        }
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon qCon = (QCon)i.current();
            if (!qCon.requiresSort()) continue;
            return true;
        }
        return false;
    }

    public QueryComparator comparator() {
        return this._comparator;
    }

    public QueryEvaluationMode evaluationMode() {
        return this._evaluationMode;
    }

    public void evaluationMode(QueryEvaluationMode mode) {
        this._evaluationMode = mode;
    }

    private void optimizeJoins() {
        if (!this.hasOrJoins()) {
            this.removeJoins();
        }
    }

    private boolean hasOrJoins() {
        return this.forEachConstraintRecursively(new Function4(){

            public Object apply(Object obj) {
                QCon constr = (QCon)obj;
                Iterator4 joinIter = constr.iterateJoins();
                while (joinIter.moveNext()) {
                    QConJoin join = (QConJoin)joinIter.current();
                    if (!join.isOr()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private void removeJoins() {
        this.forEachConstraintRecursively(new Function4(){

            public Object apply(Object obj) {
                QCon constr = (QCon)obj;
                constr.i_joins = null;
                return Boolean.FALSE;
            }
        });
    }

    private boolean forEachConstraintRecursively(Function4 block) {
        NoDuplicatesQueue queue = new NoDuplicatesQueue(new NonblockingQueue());
        Iterator4 constrIter = this.iterateConstraints();
        while (constrIter.moveNext()) {
            queue.add(constrIter.current());
        }
        while (queue.hasNext()) {
            QCon constr = (QCon)queue.next();
            Boolean cancel = (Boolean)block.apply(constr);
            if (cancel.booleanValue()) {
                return true;
            }
            Iterator4 childIter = constr.iterateChildren();
            while (childIter.moveNext()) {
                queue.add(childIter.current());
            }
            Iterator4 joinIter = constr.iterateJoins();
            while (joinIter.moveNext()) {
                queue.add(joinIter.current());
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("QQueryBase\n");
        Iterator4 i = this.iterateConstraints();
        while (i.moveNext()) {
            QCon constraint = (QCon)i.current();
            sb.append(constraint);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class CreateCandidateCollectionResult {
        public final boolean checkDuplicates;
        public final boolean topLevel;
        public final List4 candidateCollection;

        public CreateCandidateCollectionResult(List4 candidateCollection_, boolean checkDuplicates_, boolean topLevel_) {
            this.candidateCollection = candidateCollection_;
            this.topLevel = topLevel_;
            this.checkDuplicates = checkDuplicates_;
        }
    }
}

