/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.Arrays4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.fieldindex.AndIndexedLeaf;
import com.db4o.internal.fieldindex.IndexedLeaf;
import com.db4o.internal.fieldindex.IndexedNodeWithRange;
import com.db4o.internal.fieldindex.OrIndexedLeaf;
import com.db4o.internal.query.processor.QCandidates;
import com.db4o.internal.query.processor.QCon;
import com.db4o.internal.query.processor.QConJoin;
import com.db4o.internal.query.processor.QConObject;

public class IndexedNodeCollector {
    private final Collection4 _nodes = new Collection4();
    private final Hashtable4 _nodeCache = new Hashtable4();

    public IndexedNodeCollector(QCandidates candidates) {
        this.collectIndexedNodes(candidates);
    }

    public Iterator4 getNodes() {
        return this._nodes.iterator();
    }

    private void collectIndexedNodes(QCandidates candidates) {
        this.collectIndexedNodes(candidates.iterateConstraints());
        this.implicitlyAndJoinsOnSameField();
    }

    private void implicitlyAndJoinsOnSameField() {
        Object[] nodes = this._nodes.toArray();
        for (int i = 0; i < nodes.length; ++i) {
            OrIndexedLeaf current;
            OrIndexedLeaf other;
            Object node = nodes[i];
            if (!(node instanceof OrIndexedLeaf) || null == (other = this.findJoinOnSameFieldAtSameLevel(current = (OrIndexedLeaf)node))) continue;
            nodes[Arrays4.indexOf((Object[])nodes, (Object)other)] = null;
            this.collectImplicitAnd(current.getConstraint(), current, other);
        }
    }

    private OrIndexedLeaf findJoinOnSameFieldAtSameLevel(OrIndexedLeaf join) {
        Iterator4 i = this._nodes.iterator();
        while (i.moveNext()) {
            OrIndexedLeaf current;
            if (i.current() == join || !(i.current() instanceof OrIndexedLeaf) || (current = (OrIndexedLeaf)i.current()).getIndex() != join.getIndex() || this.parentConstraint(current) != this.parentConstraint(join)) continue;
            return current;
        }
        return null;
    }

    private Object parentConstraint(OrIndexedLeaf node) {
        return node.getConstraint().parent();
    }

    private void collectIndexedNodes(Iterator4 qcons) {
        while (qcons.moveNext()) {
            QCon qcon = (QCon)qcons.current();
            if (this.isCached(qcon)) continue;
            if (this.isLeaf(qcon)) {
                if (!qcon.canLoadByIndex() || !qcon.canBeIndexLeaf()) continue;
                QConObject conObject = (QConObject)qcon;
                if (conObject.hasJoins()) {
                    this.collectJoinedNode(conObject);
                    continue;
                }
                this.collectStandaloneNode(conObject);
                continue;
            }
            if (qcon.hasJoins()) continue;
            this.collectIndexedNodes(qcon.iterateChildren());
        }
    }

    private boolean isCached(QCon qcon) {
        return null != this._nodeCache.get(qcon);
    }

    private void collectStandaloneNode(QConObject conObject) {
        IndexedLeaf existing = this.findLeafOnSameField(conObject);
        if (existing != null) {
            this.collectImplicitAnd(conObject, existing, new IndexedLeaf(conObject));
        } else {
            this._nodes.add(new IndexedLeaf(conObject));
        }
    }

    private void collectJoinedNode(QConObject constraintWithJoins) {
        Collection4 joins = this.collectTopLevelJoins(constraintWithJoins);
        if (!this.canJoinsBeSearchedByIndex(joins)) {
            return;
        }
        if (1 == joins.size()) {
            this._nodes.add(this.nodeForConstraint((QCon)joins.singleElement()));
            return;
        }
        this.collectImplicitlyAndingJoins(joins, constraintWithJoins);
    }

    private boolean allHaveSamePath(Collection4 leaves) {
        Iterator4 i = leaves.iterator();
        i.moveNext();
        QCon first = (QCon)i.current();
        while (i.moveNext()) {
            if (this.haveSamePath(first, (QCon)i.current())) continue;
            return false;
        }
        return true;
    }

    private boolean haveSamePath(QCon x, QCon y) {
        if (x == y) {
            return true;
        }
        if (!x.onSameFieldAs(y)) {
            return false;
        }
        if (!x.hasParent()) {
            return !y.hasParent();
        }
        return this.haveSamePath(x.parent(), y.parent());
    }

    private Collection4 collectLeaves(Collection4 joins) {
        Collection4 leaves = new Collection4();
        this.collectLeaves(leaves, joins);
        return leaves;
    }

    private void collectLeaves(Collection4 leaves, Collection4 joins) {
        Iterator4 i = joins.iterator();
        while (i.moveNext()) {
            QConJoin join = (QConJoin)i.current();
            this.collectLeavesFromJoin(leaves, join);
        }
    }

    private void collectLeavesFromJoin(Collection4 leaves, QConJoin join) {
        this.collectLeavesFromJoinConstraint(leaves, join.i_constraint1);
        this.collectLeavesFromJoinConstraint(leaves, join.i_constraint2);
    }

    private void collectLeavesFromJoinConstraint(Collection4 leaves, QCon constraint) {
        if (constraint instanceof QConJoin) {
            this.collectLeavesFromJoin(leaves, (QConJoin)constraint);
        } else if (!leaves.containsByIdentity(constraint)) {
            leaves.add(constraint);
        }
    }

    private boolean canJoinsBeSearchedByIndex(Collection4 joins) {
        Collection4 leaves = this.collectLeaves(joins);
        return this.allHaveSamePath(leaves) && this.allCanBeSearchedByIndex(leaves);
    }

    private boolean allCanBeSearchedByIndex(Collection4 leaves) {
        Iterator4 i = leaves.iterator();
        while (i.moveNext()) {
            QCon leaf = (QCon)i.current();
            if (leaf.canLoadByIndex()) continue;
            return false;
        }
        return true;
    }

    private void collectImplicitlyAndingJoins(Collection4 joins, QConObject constraintWithJoins) {
        Iterator4 i = joins.iterator();
        i.moveNext();
        IndexedNodeWithRange last = this.nodeForConstraint((QCon)i.current());
        while (i.moveNext()) {
            IndexedNodeWithRange node = this.nodeForConstraint((QCon)i.current());
            last = new AndIndexedLeaf((QCon)constraintWithJoins, node, last);
            this._nodes.add(last);
        }
    }

    private Collection4 collectTopLevelJoins(QConObject constraintWithJoins) {
        Collection4 joins = new Collection4();
        this.collectTopLevelJoins(joins, constraintWithJoins);
        return joins;
    }

    private void collectTopLevelJoins(Collection4 joins, QCon constraintWithJoins) {
        Iterator4 i = constraintWithJoins.i_joins.iterator();
        while (i.moveNext()) {
            QConJoin join = (QConJoin)i.current();
            if (!join.hasJoins()) {
                if (joins.containsByIdentity(join)) continue;
                joins.add(join);
                continue;
            }
            this.collectTopLevelJoins(joins, join);
        }
    }

    private IndexedNodeWithRange newNodeForConstraint(QConJoin join) {
        IndexedNodeWithRange c1 = this.nodeForConstraint(join.i_constraint1);
        IndexedNodeWithRange c2 = this.nodeForConstraint(join.i_constraint2);
        if (join.isOr()) {
            return new OrIndexedLeaf(this.findLeafForJoin(join), c1, c2);
        }
        return new AndIndexedLeaf(join.i_constraint1, c1, c2);
    }

    private QCon findLeafForJoin(QConJoin join) {
        if (join.i_constraint1 instanceof QConObject) {
            return join.i_constraint1;
        }
        QCon con = join.i_constraint2;
        if (con instanceof QConObject) {
            return con;
        }
        return this.findLeafForJoin((QConJoin)con);
    }

    private IndexedNodeWithRange nodeForConstraint(QCon con) {
        IndexedNodeWithRange node = (IndexedNodeWithRange)this._nodeCache.get(con);
        if (null != node || this._nodeCache.containsKey(con)) {
            return node;
        }
        node = this.newNodeForConstraint(con);
        this._nodeCache.put(con, (Object)node);
        return node;
    }

    private IndexedNodeWithRange newNodeForConstraint(QCon con) {
        if (con instanceof QConJoin) {
            return this.newNodeForConstraint((QConJoin)con);
        }
        return new IndexedLeaf((QConObject)con);
    }

    private void collectImplicitAnd(QCon constraint, IndexedNodeWithRange x, IndexedNodeWithRange y) {
        this._nodes.remove(x);
        this._nodes.remove(y);
        this._nodes.add(new AndIndexedLeaf(constraint, x, y));
    }

    private IndexedLeaf findLeafOnSameField(QConObject conObject) {
        Iterator4 i = this._nodes.iterator();
        while (i.moveNext()) {
            IndexedLeaf leaf;
            if (!(i.current() instanceof IndexedLeaf) || !conObject.onSameFieldAs((leaf = (IndexedLeaf)i.current()).constraint())) continue;
            return leaf;
        }
        return null;
    }

    private boolean isLeaf(QCon qcon) {
        return !qcon.hasChildren();
    }
}

