/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs.messages;

import com.db4o.ext.Db4oDatabase;
import com.db4o.ext.ObjectInfo;
import com.db4o.ext.ObjectInfoCollection;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.CallbackObjectInfoCollections;
import com.db4o.internal.FrozenObjectInfo;
import com.db4o.internal.LazyObjectReference;
import com.db4o.internal.ObjectInfoCollectionImpl;
import com.db4o.internal.cs.messages.ClientSideMessage;
import com.db4o.internal.cs.messages.MsgD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MCommittedInfo
extends MsgD
implements ClientSideMessage {
    public MCommittedInfo encode(CallbackObjectInfoCollections callbackInfo) {
        byte[] bytes = this.encodeInfo(callbackInfo);
        MCommittedInfo committedInfo = (MCommittedInfo)this.getWriterForLength(this.transaction(), bytes.length);
        committedInfo._payLoad.append(bytes);
        return committedInfo;
    }

    private byte[] encodeInfo(CallbackObjectInfoCollections callbackInfo) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encodeObjectInfoCollection(os, callbackInfo.added, new InternalIDEncoder());
        this.encodeObjectInfoCollection(os, callbackInfo.deleted, new FrozenObjectInfoEncoder());
        this.encodeObjectInfoCollection(os, callbackInfo.updated, new InternalIDEncoder());
        return os.toByteArray();
    }

    private void encodeObjectInfoCollection(ByteArrayOutputStream os, ObjectInfoCollection collection, ObjectInfoEncoder encoder) {
        Iterator4 iter = collection.iterator();
        while (iter.moveNext()) {
            ObjectInfo obj = (ObjectInfo)iter.current();
            encoder.encode(os, obj);
        }
        this.writeLong(os, -1L);
    }

    public CallbackObjectInfoCollections decode() {
        ByteArrayInputStream is = new ByteArrayInputStream(this._payLoad._buffer);
        ObjectInfoCollection added = this.decodeObjectInfoCollection(is, new InternalIDEncoder());
        ObjectInfoCollection deleted = this.decodeObjectInfoCollection(is, new FrozenObjectInfoEncoder());
        ObjectInfoCollection updated = this.decodeObjectInfoCollection(is, new InternalIDEncoder());
        return new CallbackObjectInfoCollections(added, updated, deleted);
    }

    private ObjectInfoCollection decodeObjectInfoCollection(ByteArrayInputStream is, ObjectInfoEncoder encoder) {
        ObjectInfo info;
        Collection4 collection = new Collection4();
        while (null != (info = encoder.decode(is))) {
            collection.add(info);
        }
        return new ObjectInfoCollectionImpl(collection);
    }

    private void writeLong(ByteArrayOutputStream os, long l) {
        for (int i = 0; i < 64; i += 8) {
            os.write((int)(l >> i));
        }
    }

    private long readLong(ByteArrayInputStream is) {
        long l = 0L;
        for (int i = 0; i < 64; i += 8) {
            l += (long)is.read() << i;
        }
        return l;
    }

    public boolean processAtClient() {
        final CallbackObjectInfoCollections callbackInfos = this.decode();
        new Thread(new Runnable(){

            public void run() {
                if (MCommittedInfo.this.stream().isClosed()) {
                    return;
                }
                MCommittedInfo.this.stream().callbacks().commitOnCompleted(MCommittedInfo.this.transaction(), callbackInfos);
            }
        }).start();
        return true;
    }

    protected void writeByteArray(ByteArrayOutputStream os, byte[] signaturePart) throws IOException {
        this.writeLong(os, signaturePart.length);
        os.write(signaturePart);
    }

    static interface ObjectInfoEncoder {
        public void encode(ByteArrayOutputStream var1, ObjectInfo var2);

        public ObjectInfo decode(ByteArrayInputStream var1);
    }

    private final class InternalIDEncoder
    implements ObjectInfoEncoder {
        private InternalIDEncoder() {
        }

        public void encode(ByteArrayOutputStream os, ObjectInfo info) {
            MCommittedInfo.this.writeLong(os, info.getInternalID());
        }

        public ObjectInfo decode(ByteArrayInputStream is) {
            long id = MCommittedInfo.this.readLong(is);
            if (id == -1L) {
                return null;
            }
            return new LazyObjectReference(MCommittedInfo.this.transaction(), (int)id);
        }
    }

    private final class FrozenObjectInfoEncoder
    implements ObjectInfoEncoder {
        private FrozenObjectInfoEncoder() {
        }

        public void encode(ByteArrayOutputStream os, ObjectInfo info) {
            MCommittedInfo.this.writeLong(os, info.getInternalID());
            long sourceDatabaseId = ((FrozenObjectInfo)info).sourceDatabaseId(MCommittedInfo.this.transaction());
            MCommittedInfo.this.writeLong(os, sourceDatabaseId);
            MCommittedInfo.this.writeLong(os, ((FrozenObjectInfo)info).uuidLongPart());
            MCommittedInfo.this.writeLong(os, info.getVersion());
        }

        public ObjectInfo decode(ByteArrayInputStream is) {
            long id = MCommittedInfo.this.readLong(is);
            if (id == -1L) {
                return null;
            }
            long sourceDatabaseId = MCommittedInfo.this.readLong(is);
            Db4oDatabase sourceDatabase = null;
            if (sourceDatabaseId > 0L) {
                sourceDatabase = (Db4oDatabase)MCommittedInfo.this.stream().getByID(MCommittedInfo.this.transaction(), sourceDatabaseId);
            }
            long uuidLongPart = MCommittedInfo.this.readLong(is);
            long version = MCommittedInfo.this.readLong(is);
            return new FrozenObjectInfo(null, id, sourceDatabase, uuidLongPart, version);
        }
    }
}

