/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgD;

final class ClientTransaction
extends Transaction {
    private final ClientObjectContainer i_client;
    protected Tree i_yapObjectsToGc;

    ClientTransaction(ClientObjectContainer container, Transaction parentTransaction, TransactionalReferenceSystem referenceSystem) {
        super(container, parentTransaction, referenceSystem);
        this.i_client = container;
    }

    public void commit() {
        this.commitTransactionListeners();
        this.clearAll();
        if (this.isSystemTransaction()) {
            this.i_client.write(Msg.COMMIT_SYSTEMTRANS);
        } else {
            this.i_client.write(Msg.COMMIT);
            this.i_client.expectedResponse(Msg.OK);
        }
    }

    protected void clear() {
        this.removeYapObjectReferences();
    }

    private void removeYapObjectReferences() {
        if (this.i_yapObjectsToGc != null) {
            this.i_yapObjectsToGc.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    ObjectReference yo = (ObjectReference)((TreeIntObject)a_object)._object;
                    ClientTransaction.this.removeReference(yo);
                }
            });
        }
        this.i_yapObjectsToGc = null;
    }

    public boolean delete(ObjectReference ref, int id, int cascade) {
        if (!super.delete(ref, id, cascade)) {
            return false;
        }
        MsgD msg = Msg.TA_DELETE.getWriterForInts(this, new int[]{id, cascade});
        this.i_client.writeBatchedMessage(msg);
        return true;
    }

    public boolean isDeleted(int a_id) {
        MsgD msg = Msg.TA_IS_DELETED.getWriterForInt(this, a_id);
        this.i_client.write(msg);
        int res = this.i_client.expectedByteResponse(Msg.TA_IS_DELETED).readInt();
        return res == 1;
    }

    public final HardObjectReference getHardReferenceBySignature(long a_uuid, byte[] a_signature) {
        int messageLength = 12 + a_signature.length;
        MsgD message = Msg.OBJECT_BY_UUID.getWriterForLength(this, messageLength);
        message.writeLong(a_uuid);
        message.writeBytes(a_signature);
        this.i_client.write(message);
        message = (MsgD)this.i_client.expectedResponse(Msg.OBJECT_BY_UUID);
        int id = message.readInt();
        if (id > 0) {
            return this.container().getHardObjectReferenceById(this, id);
        }
        return HardObjectReference.INVALID;
    }

    public void processDeletes() {
        if (this._delete != null) {
            this._delete.traverse(new Visitor4(){

                public void visit(Object a_object) {
                    DeleteInfo info = (DeleteInfo)a_object;
                    if (info._reference != null) {
                        ClientTransaction.this.i_yapObjectsToGc = Tree.add(ClientTransaction.this.i_yapObjectsToGc, new TreeIntObject(info._key, info._reference));
                    }
                }
            });
        }
        this._delete = null;
        this.i_client.writeBatchedMessage(Msg.PROCESS_DELETES);
    }

    public void rollback() {
        this.i_yapObjectsToGc = null;
        this.rollBackTransactionListeners();
        this.clearAll();
    }

    public void writeUpdateDeleteMembers(int a_id, ClassMetadata a_yc, int a_type, int a_cascade) {
        MsgD msg = Msg.WRITE_UPDATE_DELETE_MEMBERS.getWriterForInts(this, new int[]{a_id, a_yc.getID(), a_type, a_cascade});
        this.i_client.writeBatchedMessage(msg);
    }
}

