/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.foundation.Procedure4;
import com.db4o.foundation.TreeKeyIterator;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.TreeInt;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.slots.Slot;

final class FirstPassCommand
implements PassCommand {
    private static final int ID_BATCH_SIZE = 4096;
    private TreeInt _ids;

    FirstPassCommand() {
    }

    void process(DefragmentServicesImpl context, int objectID, boolean isClassID) {
        if (this.batchFull()) {
            this.flush(context);
        }
        this._ids = TreeInt.add(this._ids, isClassID ? -objectID : objectID);
    }

    private boolean batchFull() {
        return this._ids != null && this._ids.size() == 4096;
    }

    public void processClass(final DefragmentServicesImpl context, ClassMetadata classMetadata, int id, int classIndexID) {
        this.process(context, id, true);
        classMetadata.forEachField(new Procedure4(){

            public void apply(Object arg) {
                FieldMetadata field = (FieldMetadata)arg;
                if (!field.isVirtual() && field.hasIndex()) {
                    FirstPassCommand.this.processBTree(context, field.getIndex(context.systemTrans()));
                }
            }
        });
    }

    public void processObjectSlot(DefragmentServicesImpl context, ClassMetadata yapClass, int sourceID) {
        this.process(context, sourceID, false);
    }

    public void processClassCollection(DefragmentServicesImpl context) throws CorruptionException {
        this.process(context, context.sourceClassCollectionID(), false);
    }

    public void processBTree(final DefragmentServicesImpl context, BTree btree) {
        this.process(context, btree.getID(), false);
        context.traverseAllIndexSlots(btree, new Visitor4(){

            public void visit(Object obj) {
                int id = (Integer)obj;
                FirstPassCommand.this.process(context, id, false);
            }
        });
    }

    public void flush(DefragmentServicesImpl context) {
        if (this._ids == null) {
            return;
        }
        int blockSize = context.blockSize();
        boolean overlapping = 8 % blockSize > 0;
        int blocksPerPointer = 8 / blockSize;
        if (overlapping) {
            ++blocksPerPointer;
        }
        int bytesPerPointer = blocksPerPointer * blockSize;
        int batchSize = this._ids.size() * bytesPerPointer;
        Slot pointerSlot = context.allocateTargetSlot(batchSize);
        int pointerAddress = pointerSlot.address();
        TreeKeyIterator idIter = new TreeKeyIterator(this._ids);
        while (idIter.moveNext()) {
            int objectID = (Integer)idIter.current();
            boolean isClassID = false;
            if (objectID < 0) {
                objectID = -objectID;
                isClassID = true;
            }
            context.mapIDs(objectID, pointerAddress, isClassID);
            pointerAddress += blocksPerPointer;
        }
        this._ids = null;
    }
}

