/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.metadata;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericReflector;
import com.spaceprogram.db4o.sql.ClassRef;
import com.spaceprogram.db4o.sql.ObjectSetMetaData;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Sql4oRuntimeException;
import com.spaceprogram.db4o.sql.query.From;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.ArrayList;
import java.util.List;

public class ObjectSetMetaDataImpl
implements ObjectSetMetaData {
    private List<String> fields = new ArrayList<String>();
    private List<ReflectField> reflectFields = new ArrayList<ReflectField>();

    public ObjectSetMetaDataImpl(ObjectSet objectSet, ObjectSetWrapper objectSetWrapper, ObjectContainer objectContainer, SqlQuery sqlQuery) {
        this.init(objectSet, objectSetWrapper, objectContainer, sqlQuery);
    }

    private void init(ObjectSet objectSet, ObjectSetWrapper objectSetWrapper, ObjectContainer objectContainer, SqlQuery sqlQuery) {
        From from = sqlQuery.getFrom();
        List<ClassRef> list = from.getClassRefs();
        for (int i = 0; i < list.size(); ++i) {
            ClassRef classRef = list.get(i);
            String string = classRef.getClassName();
            GenericReflector genericReflector = objectContainer.ext().reflector();
            ReflectClass reflectClass = genericReflector.forName(string);
            ReflectField[] reflectFieldArray = this.getDeclaredFields(reflectClass);
            for (int j = 0; j < reflectFieldArray.length; ++j) {
                ReflectField reflectField = reflectFieldArray[j];
                if (objectSetWrapper.hasSelectFields()) {
                    if (!objectSetWrapper.getSelectFields().contains(reflectField.getName())) continue;
                    this.reflectFields.add(reflectField);
                    this.fields.add(reflectField.getName());
                    continue;
                }
                this.reflectFields.add(reflectField);
                this.fields.add(reflectField.getName());
            }
        }
    }

    private ReflectField[] getDeclaredFields(ReflectClass reflectClass) {
        return ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
    }

    public int getColumnCount() {
        return this.fields.size();
    }

    public String getColumnName(int n) {
        if (n >= 0 && n < this.fields.size()) {
            return this.fields.get(n);
        }
        return null;
    }

    public ReflectField getColumnReflectField(int n) {
        if (this.reflectFields.size() <= n || n < 0) {
            throw new Sql4oRuntimeException("Field index out of bounds. received: " + n + " max: " + this.reflectFields.size());
        }
        ReflectField reflectField = this.reflectFields.get(n);
        return reflectField;
    }

    public ReflectField getColumnReflectField(String string) {
        for (int i = 0; i < this.reflectFields.size(); ++i) {
            ReflectField reflectField = this.reflectFields.get(i);
            if (!reflectField.getName().equals(string)) continue;
            return reflectField;
        }
        return null;
    }
}

