/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql.jdbc;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.spaceprogram.db4o.sql.jdbc.Db4oConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class Db4oDriver
implements Driver {
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    private static final String DRIVER_NAME = "db4o JDBC Driver";

    public Db4oDriver() {
        System.out.println("LOADING DB4O DRIVER");
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        String string22;
        String string3 = properties.getProperty("user");
        String string4 = properties.getProperty("password");
        String[] stringArray = string.split("//");
        if (stringArray.length < 2) {
            this.throwBadUrlException(string);
        }
        for (String string22 : stringArray) {
            System.out.println(string22);
        }
        String[] stringArray2 = stringArray[1].split(":");
        if (stringArray2.length < 2) {
            this.throwBadUrlException(string);
        }
        String string5 = null;
        int n = 0;
        try {
            string5 = stringArray2[0];
            n = Integer.parseInt(stringArray2[1]);
        }
        catch (Exception exception) {
            this.throwBadUrlException(string);
        }
        string22 = null;
        try {
            string22 = Db4o.openClient((String)string5, (int)n, (String)string3, (String)string4);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
        return new Db4oConnection(this, (ObjectContainer)string22);
    }

    private void throwBadUrlException(String string) throws SQLException {
        throw new SQLException("JDBC url is not valid [" + string + "].  Must be of the form: jdbc:db4o://HOSTNAME:PORT");
    }

    public boolean acceptsURL(String string) throws SQLException {
        return string.contains("db4o");
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public static String getVersion() {
        return "1.0";
    }

    public static String getDriverName() {
        return DRIVER_NAME;
    }

    static {
        try {
            Db4oDriver db4oDriver = new Db4oDriver();
            DriverManager.registerDriver(db4oDriver);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

