/*
 * Decompiled with CFR 0.152.
 */
package com.spaceprogram.db4o.sql;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Constraint;
import com.db4o.query.Query;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.jdk.JdkReflector;
import com.spaceprogram.db4o.sql.ClassRef;
import com.spaceprogram.db4o.sql.Converter;
import com.spaceprogram.db4o.sql.ObjectSetWrapper;
import com.spaceprogram.db4o.sql.Result;
import com.spaceprogram.db4o.sql.Sql4oException;
import com.spaceprogram.db4o.sql.query.OrderBy;
import com.spaceprogram.db4o.sql.query.SqlQuery;
import com.spaceprogram.db4o.sql.query.WhereExpression;
import com.spaceprogram.db4o.sql.util.ReflectHelper;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlToSoda {
    public static boolean allowClassNotFound = true;

    public static List<Result> execute(ObjectContainer objectContainer, SqlQuery sqlQuery) throws Sql4oException {
        Object object;
        Query query = objectContainer.query();
        for (int i = 0; i < sqlQuery.getFrom().getClassRefs().size(); ++i) {
            object = sqlQuery.getFrom().getClassRefs().get(i);
            String string = ((ClassRef)object).getClassName();
            ReflectClass reflectClass = objectContainer.ext().reflector().forName(string);
            if (reflectClass == null) {
                throw new Sql4oException("Class not stored: " + string);
            }
            query.constrain((Object)reflectClass);
            SqlToSoda.verifySelectFields(reflectClass, sqlQuery);
            SqlToSoda.applyWhere(reflectClass, query, sqlQuery);
            SqlToSoda.applyOrderBy(reflectClass, query, sqlQuery);
        }
        ObjectSet objectSet = query.execute();
        object = new ObjectSetWrapper(objectContainer, sqlQuery, objectSet);
        return object;
    }

    private static void verifySelectFields(ReflectClass reflectClass, SqlQuery sqlQuery) throws Sql4oException {
        List<String> list;
        if (sqlQuery.getSelect() != null && (list = sqlQuery.getSelect().getFields()) != null) {
            if (list.size() == 1 && list.get(0).equals("*")) {
                return;
            }
            ReflectField[] reflectFieldArray = ReflectHelper.getDeclaredFieldsInHeirarchy(reflectClass);
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                boolean bl = false;
                for (int j = 0; j < reflectFieldArray.length; ++j) {
                    ReflectField reflectField = reflectFieldArray[j];
                    if (!reflectField.getName().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new Sql4oException("Field not found: " + string);
            }
        }
    }

    private static void applyWhere(ReflectClass reflectClass, Query query, SqlQuery sqlQuery) throws Sql4oException {
        if (sqlQuery.getWhere() != null) {
            WhereExpression whereExpression = sqlQuery.getWhere().getRoot();
            SqlToSoda.applyWhereRecursive(reflectClass, query, sqlQuery, whereExpression);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void applyWhereRecursive(ReflectClass reflectClass, Query query, SqlQuery sqlQuery, WhereExpression whereExpression) throws Sql4oException {
        try {
            List<WhereExpression> list = whereExpression.getExpressions();
            Constraint constraint = null;
            if (!whereExpression.isRoot()) {
                // empty if block
            }
            for (int i = 0; i < list.size(); ++i) {
                WhereExpression whereExpression2 = list.get(i);
                if (whereExpression2.getExpressions() != null && whereExpression2.getExpressions().size() > 0) {
                    SqlToSoda.applyWhereRecursive(reflectClass, query, sqlQuery, whereExpression2);
                    continue;
                }
                Constraint constraint2 = SqlToSoda.makeConstraint(reflectClass, query, whereExpression2, sqlQuery);
                if (constraint != null && whereExpression2.getType().equalsIgnoreCase("OR")) {
                    constraint.or(constraint2);
                }
                constraint = constraint2;
            }
            if (whereExpression.isRoot()) return;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new Sql4oException("Could not apply where conditions.  Exception: " + cloneNotSupportedException.getMessage());
        }
    }

    private static Constraint makeConstraint(ReflectClass reflectClass, Query query, WhereExpression whereExpression, SqlQuery sqlQuery) throws CloneNotSupportedException, Sql4oException {
        Constraint constraint;
        Object object;
        String[] stringArray = whereExpression.getField().split("\\.");
        Query query2 = query;
        ReflectField reflectField = null;
        ReflectClass reflectClass2 = reflectClass;
        block2: for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (i == 0) {
                constraint = sqlQuery.getFrom().getClassRefs();
                for (int j = 0; j < constraint.size(); ++j) {
                    ClassRef classRef = (ClassRef)constraint.get(j);
                    String string = classRef.getAlias();
                    if (string != null && string.equals(stringArray[0])) continue block2;
                }
            }
            if ((reflectField = ReflectHelper.getDeclaredFieldInHeirarchy(reflectClass2, (String)object)) == null) {
                throw new Sql4oException("Field not found: " + whereExpression.getField());
            }
            reflectClass2 = reflectField.getFieldType();
            query2 = query2.descend((String)object);
        }
        if (reflectField == null) {
            throw new Sql4oException("Field not found: " + whereExpression.getField());
        }
        Class clazz = JdkReflector.toNative((ReflectClass)reflectClass2);
        object = null;
        try {
            object = SqlToSoda.convertStringToObjectValue(clazz, whereExpression);
        }
        catch (Exception exception) {
            object = null;
        }
        if (object == null) {
            throw new Sql4oException("Could not create where condition value object! " + whereExpression.getValue() + " for field type " + reflectClass2);
        }
        constraint = query2.constrain(object);
        SqlToSoda.applyOperator(reflectClass, constraint, whereExpression.getOperator(), query, whereExpression, sqlQuery);
        return constraint;
    }

    private static Object convertStringToObjectValue(Class clazz, WhereExpression whereExpression) throws Exception {
        String string = whereExpression.getValue();
        if (clazz == String.class) {
            string = SqlToSoda.cleanValue(string);
        } else if (clazz == Date.class) {
            string = SqlToSoda.cleanValue(string);
        }
        return Converter.convertFromString(clazz, string);
    }

    private static String cleanValue(String string) {
        string = string.replace("'", "");
        return string;
    }

    private static void applyOperator(ReflectClass reflectClass, Constraint constraint, String string, Query query, WhereExpression whereExpression, SqlQuery sqlQuery) throws CloneNotSupportedException, Sql4oException {
        if (string.equals(">")) {
            constraint.greater();
        } else if (string.equals("<")) {
            constraint.smaller();
        } else if (string.equals(">=")) {
            constraint.greater();
            WhereExpression whereExpression2 = (WhereExpression)whereExpression.clone();
            whereExpression2.setOperator("=");
            constraint.or(SqlToSoda.makeConstraint(reflectClass, query, whereExpression2, sqlQuery));
        } else if (string.equals("<=")) {
            constraint.smaller();
            WhereExpression whereExpression3 = (WhereExpression)whereExpression.clone();
            whereExpression3.setOperator("=");
            constraint.or(SqlToSoda.makeConstraint(reflectClass, query, whereExpression3, sqlQuery));
        } else if (string.equals("<>") || string.equals("!=")) {
            constraint.not();
        } else {
            constraint.equal();
        }
    }

    private static void applyOrderBy(ReflectClass reflectClass, Query query, SqlQuery sqlQuery) {
        OrderBy orderBy = sqlQuery.getOrderBy();
        if (orderBy != null) {
            List<OrderBy.Field> list = orderBy.getFields();
            for (int i = 0; i < list.size(); ++i) {
                OrderBy.Field field = list.get(i);
                System.out.println("ordering by: " + field);
                if (field.isAscending()) {
                    query.descend(field.getName()).orderAscending();
                    continue;
                }
                query.descend(field.getName()).orderDescending();
            }
        }
    }
}

