/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CatchExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiCatchStmt;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;

public abstract class TreeVisitor {
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;
    boolean prune;
    int direction;

    public TreeVisitor() {
        this(0);
    }

    public TreeVisitor(int direction) {
        this.direction = direction;
    }

    public void setPrune(boolean prune) {
        this.prune = prune;
    }

    public boolean prune() {
        return this.prune;
    }

    public int direction() {
        return this.direction;
    }

    public boolean forward() {
        return this.direction == 0;
    }

    public boolean reverse() {
        return this.direction == 1;
    }

    public void visitFlowGraph(FlowGraph graph) {
        graph.visitChildren(this);
    }

    public void visitBlock(Block block) {
        block.visitChildren(this);
    }

    public void visitTree(Tree tree) {
        this.visitNode(tree);
    }

    public void visitExprStmt(ExprStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitIfStmt(IfStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        this.visitIfStmt(stmt);
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        this.visitIfStmt(stmt);
    }

    public void visitInitStmt(InitStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitGotoStmt(GotoStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitLabelStmt(LabelStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitMonitorStmt(MonitorStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitPhiStmt(PhiStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitCatchExpr(CatchExpr expr) {
        this.visitExpr(expr);
    }

    public void visitDefExpr(DefExpr expr) {
        this.visitExpr(expr);
    }

    public void visitStackManipStmt(StackManipStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitPhiCatchStmt(PhiCatchStmt stmt) {
        this.visitPhiStmt(stmt);
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
        this.visitPhiStmt(stmt);
    }

    public void visitRetStmt(RetStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitReturnExprStmt(ReturnExprStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitReturnStmt(ReturnStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitAddressStoreStmt(AddressStoreStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitStoreExpr(StoreExpr expr) {
        this.visitExpr(expr);
    }

    public void visitJsrStmt(JsrStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitThrowStmt(ThrowStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitStmt(Stmt stmt) {
        this.visitNode(stmt);
    }

    public void visitSCStmt(SCStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitSRStmt(SRStmt stmt) {
        this.visitStmt(stmt);
    }

    public void visitArithExpr(ArithExpr expr) {
        this.visitExpr(expr);
    }

    public void visitArrayLengthExpr(ArrayLengthExpr expr) {
        this.visitExpr(expr);
    }

    public void visitMemExpr(MemExpr expr) {
        this.visitDefExpr(expr);
    }

    public void visitMemRefExpr(MemRefExpr expr) {
        this.visitMemExpr(expr);
    }

    public void visitArrayRefExpr(ArrayRefExpr expr) {
        this.visitMemRefExpr(expr);
    }

    public void visitCallExpr(CallExpr expr) {
        this.visitExpr(expr);
    }

    public void visitCallMethodExpr(CallMethodExpr expr) {
        this.visitCallExpr(expr);
    }

    public void visitCallStaticExpr(CallStaticExpr expr) {
        this.visitCallExpr(expr);
    }

    public void visitCastExpr(CastExpr expr) {
        this.visitExpr(expr);
    }

    public void visitConstantExpr(ConstantExpr expr) {
        this.visitExpr(expr);
    }

    public void visitFieldExpr(FieldExpr expr) {
        this.visitMemRefExpr(expr);
    }

    public void visitInstanceOfExpr(InstanceOfExpr expr) {
        this.visitExpr(expr);
    }

    public void visitLocalExpr(LocalExpr expr) {
        this.visitVarExpr(expr);
    }

    public void visitNegExpr(NegExpr expr) {
        this.visitExpr(expr);
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        this.visitExpr(expr);
    }

    public void visitNewExpr(NewExpr expr) {
        this.visitExpr(expr);
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        this.visitExpr(expr);
    }

    public void visitCheckExpr(CheckExpr expr) {
        this.visitExpr(expr);
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        this.visitCheckExpr(expr);
    }

    public void visitRCExpr(RCExpr expr) {
        this.visitCheckExpr(expr);
    }

    public void visitUCExpr(UCExpr expr) {
        this.visitCheckExpr(expr);
    }

    public void visitReturnAddressExpr(ReturnAddressExpr expr) {
        this.visitExpr(expr);
    }

    public void visitShiftExpr(ShiftExpr expr) {
        this.visitExpr(expr);
    }

    public void visitStackExpr(StackExpr expr) {
        this.visitVarExpr(expr);
    }

    public void visitVarExpr(VarExpr expr) {
        this.visitMemExpr(expr);
    }

    public void visitStaticFieldExpr(StaticFieldExpr expr) {
        this.visitMemRefExpr(expr);
    }

    public void visitExpr(Expr expr) {
        this.visitNode(expr);
    }

    public void visitNode(Node node) {
        node.visitChildren(this);
    }
}

