/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectmanager.model;

import com.db4o.objectmanager.model.GraphPathNode;
import com.db4o.objectmanager.model.GraphPosition;
import com.db4o.objectmanager.model.IDatabase;
import com.db4o.objectmanager.model.IGraphIterator;
import com.db4o.objectmanager.model.IGraphIteratorSelectionListener;
import com.db4o.objectmanager.model.nodes.IModelNode;
import java.util.LinkedList;

public abstract class AbstractGraphIterator
implements IGraphIterator {
    protected IDatabase database;
    protected IModelNode[] startModel;
    private GraphPosition path = new GraphPosition();
    private IModelNode[] currentFamily;
    private int currentIndex = -1;
    private LinkedList selectionChangedListeners = new LinkedList();

    public GraphPosition getPath() {
        GraphPosition graphPosition = new GraphPosition(this.path);
        graphPosition.push(this.currentFamily, this.getCurrentIndex());
        return graphPosition;
    }

    public void setPath(GraphPosition graphPosition) {
        GraphPosition graphPosition2 = new GraphPosition(graphPosition);
        GraphPathNode graphPathNode = graphPosition2.pop();
        this.currentFamily = graphPathNode.children;
        this.setCurrentIndex(graphPathNode.selectedChild);
        this.path = graphPosition2;
    }

    public IModelNode[] getCurrentFamily() {
        return this.currentFamily;
    }

    public boolean isPathSelectionChangable() {
        return this.fireSelectionChangeQuery();
    }

    public boolean setSelectedPath(GraphPosition graphPosition) {
        if (!this.isPathSelectionChangable()) {
            return false;
        }
        this.setPath(graphPosition);
        this.fireSelectionChangedEvent();
        return true;
    }

    private void fireSelectionChangedEvent() {
        for (IGraphIteratorSelectionListener iGraphIteratorSelectionListener : this.selectionChangedListeners) {
            iGraphIteratorSelectionListener.selectionChanged();
        }
    }

    private boolean fireSelectionChangeQuery() {
        for (IGraphIteratorSelectionListener iGraphIteratorSelectionListener : this.selectionChangedListeners) {
            if (iGraphIteratorSelectionListener.canSelectionChange()) continue;
            return false;
        }
        return true;
    }

    public void addSelectionChangedListener(IGraphIteratorSelectionListener iGraphIteratorSelectionListener) {
        this.selectionChangedListeners.add(iGraphIteratorSelectionListener);
    }

    public void removeSelectionChangedListener(IGraphIteratorSelectionListener iGraphIteratorSelectionListener) {
        this.selectionChangedListeners.remove(iGraphIteratorSelectionListener);
    }

    public boolean nextHasChildren() {
        if (!this.hasNext()) {
            return false;
        }
        return this.currentFamily[this.getCurrentIndex() + 1].hasChildren();
    }

    public boolean previousHasChildren() {
        if (!this.hasPrevious()) {
            return false;
        }
        return this.currentFamily[this.getCurrentIndex()].hasChildren();
    }

    public boolean hasParent() {
        return this.path.hasParent();
    }

    public void reset() {
        this.path = new GraphPosition();
        this.currentFamily = this.startModel;
        this.setCurrentIndex(-1);
    }

    public IModelNode selectNextChild() {
        if (!this.hasNext()) {
            throw new IllegalArgumentException("There is no next child to select");
        }
        IModelNode iModelNode = (IModelNode)this.next();
        this.previous();
        this.path.push(this.currentFamily, this.getCurrentIndex());
        this.currentFamily = iModelNode.children();
        this.setCurrentIndex(-1);
        return iModelNode;
    }

    public void selectPreviousChild() {
        if (!this.hasPrevious()) {
            throw new IllegalArgumentException("There is no previous child to select");
        }
        IModelNode iModelNode = (IModelNode)this.previous();
        this.path.push(this.currentFamily, this.getCurrentIndex());
        this.currentFamily = iModelNode.children();
        this.setCurrentIndex(-1);
    }

    public void selectParent() {
        if (!this.hasParent()) {
            throw new IllegalArgumentException("Already at top level of graph");
        }
        GraphPathNode graphPathNode = this.path.pop();
        this.currentFamily = graphPathNode.children;
        this.setCurrentIndex(graphPathNode.selectedChild);
    }

    public void add(Object object) {
    }

    public int numChildren() {
        return this.currentFamily.length;
    }

    public boolean hasNext() {
        return this.getCurrentIndex() < this.currentFamily.length - 1;
    }

    public boolean hasPrevious() {
        return this.getCurrentIndex() >= 0;
    }

    public Object next() {
        this.setCurrentIndex(this.getCurrentIndex() + 1);
        return this.currentFamily[this.getCurrentIndex()];
    }

    public int nextIndex() {
        return this.getCurrentIndex() + 1;
    }

    public Object previous() {
        IModelNode iModelNode = this.currentFamily[this.getCurrentIndex()];
        this.setCurrentIndex(this.getCurrentIndex() - 1);
        return iModelNode;
    }

    public int previousIndex() {
        return this.getCurrentIndex();
    }

    private void setCurrentIndex(int n) {
        this.currentIndex = n;
    }

    private int getCurrentIndex() {
        return this.currentIndex;
    }

    public void remove() {
    }

    public void set(Object object) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractGraphIterator)) {
            return false;
        }
        return object.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return this.path.hashCode() + this.currentFamily.length + this.getCurrentIndex() + 1;
    }
}

