/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.instrumentation.ant;

import com.db4o.instrumentation.ant.AntJarEntryInstrumentationClassSource;
import com.db4o.instrumentation.core.ClassFilter;
import com.db4o.instrumentation.file.FileInstrumentationClassSource;
import com.db4o.instrumentation.file.FilePathRoot;
import com.db4o.instrumentation.util.BloatUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.types.resources.FileResource;

class AntFileSetPathRoot
implements FilePathRoot,
ClassFilter {
    private FileSet[] _fileSets;
    private DirectoryScanner[] _scanners;

    public AntFileSetPathRoot(FileSet[] fileSets) {
        this._fileSets = fileSets;
        this._scanners = new DirectoryScanner[this._fileSets.length];
        for (int fileSetIdx = 0; fileSetIdx < this._fileSets.length; ++fileSetIdx) {
            DirectoryScanner scanner = this._fileSets[fileSetIdx].getDirectoryScanner();
            scanner.scan();
            this._scanners[fileSetIdx] = scanner;
        }
    }

    public Iterator files() {
        return new FileSetIterator(this._fileSets);
    }

    public String[] rootDirs() throws IOException {
        String[] rootDirs = new String[this._fileSets.length];
        for (int rootIdx = 0; rootIdx < this._fileSets.length; ++rootIdx) {
            FileSet curFileSet = this._fileSets[rootIdx];
            File rootDir = curFileSet.getDir();
            if (rootDir == null && curFileSet instanceof ZipFileSet) {
                ZipFileSet zipFileSet = (ZipFileSet)curFileSet;
                rootDir = zipFileSet.getSrc();
            }
            if (rootDir == null) {
                rootDir = File.listRoots()[0];
            }
            rootDirs[rootIdx] = rootDir.getCanonicalPath();
        }
        return rootDirs;
    }

    public boolean accept(Class clazz) {
        for (int scannerIdx = 0; scannerIdx < this._scanners.length; ++scannerIdx) {
            DirectoryScanner scanner = this._scanners[scannerIdx];
            String[] files = scanner.getIncludedFiles();
            for (int fileIdx = 0; fileIdx < files.length; ++fileIdx) {
                String fileName = files[fileIdx];
                String clazzName = BloatUtil.classNameForPath(fileName);
                if (!clazz.getName().equals(clazzName)) continue;
                return true;
            }
        }
        return false;
    }

    private static class FileSetIterator
    implements Iterator {
        private final FileSet[] _fileSets;
        private int _fileSetIdx;
        private Iterator _fileSetIter;

        public FileSetIterator(FileSet[] fileSets) {
            this._fileSets = fileSets;
            this.advanceFileSet();
        }

        public boolean hasNext() {
            return this._fileSetIter.hasNext();
        }

        public Object next() {
            Resource resource = (Resource)this._fileSetIter.next();
            this.advanceFileSet();
            if (resource instanceof FileResource) {
                FileResource fileRes = (FileResource)resource;
                return new FileInstrumentationClassSource(fileRes.getBaseDir(), fileRes.getFile());
            }
            return new AntJarEntryInstrumentationClassSource(resource);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceFileSet() {
            while (!(this._fileSetIter != null && this._fileSetIter.hasNext() || this._fileSetIdx >= this._fileSets.length)) {
                this._fileSetIter = this._fileSets[this._fileSetIdx].iterator();
                ++this._fileSetIdx;
            }
        }
    }
}

