/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.tree;

import com.db4o.objectManager.v2.MainPanel;
import com.db4o.objectManager.v2.tree.ObjectTreeNode;
import java.awt.Component;
import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.JTree;

public class ObjectTreeCellEditor
extends DefaultCellEditor {
    public ObjectTreeCellEditor(final JTextField textField) {
        super(textField);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            public void setValue(Object value) {
                if (value instanceof ObjectTreeNode) {
                    ObjectTreeNode node = (ObjectTreeNode)value;
                    ObjectTreeCellEditor.this.setValueOnTextField(node.getObject(), textField);
                } else {
                    ObjectTreeCellEditor.this.setValueOnTextField(value, textField);
                }
            }

            public Object getCellEditorValue() {
                return textField.getText();
            }
        };
        textField.addActionListener(this.delegate);
    }

    private void setValueOnTextField(Object value, JTextField textField) {
        String text = "";
        if (value != null) {
            text = value instanceof Date ? MainPanel.dateFormatter.edit((Date)value) : value.toString();
        }
        textField.setText(text);
    }

    public ObjectTreeCellEditor(JCheckBox checkBox) {
        super(checkBox);
    }

    public ObjectTreeCellEditor(JComboBox comboBox) {
        super(comboBox);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.delegate.setValue(value);
        return this.editorComponent;
    }
}

