/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.custom;

import java.awt.Point;
import javax.swing.BoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FastScrollPane
extends JScrollPane {
    public FastScrollPane(JTable table) {
        super(table);
        this.setUI(new FastScrollPaneUI(table));
    }

    class FastScrollPaneUI
    extends BasicScrollPaneUI {
        JTable table;

        public FastScrollPaneUI(JTable table) {
            this.table = table;
        }

        protected ChangeListener createVSBChangeListener() {
            return new myVSBChangeListener();
        }

        protected ChangeListener createHSBChangeListener() {
            return new myHSBChangeListener();
        }

        protected ChangeListener createViewportChangeListener() {
            return new myViewportChangeHandler();
        }

        public class myVSBChangeListener
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = FastScrollPaneUI.this.scrollpane.getViewport();
                if (viewport != null) {
                    BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                    Point p = viewport.getViewPosition();
                    p.y = model.getValue();
                    JScrollBar sb = FastScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (!sb.getValueIsAdjusting()) {
                        viewport.setViewPosition(p);
                    }
                }
            }
        }

        public class myHSBChangeListener
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                JViewport viewport = FastScrollPaneUI.this.scrollpane.getViewport();
                if (viewport != null) {
                    BoundedRangeModel model = (BoundedRangeModel)e.getSource();
                    Point p = viewport.getViewPosition();
                    p.x = model.getValue();
                    JScrollBar sb = FastScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                    if (!sb.getValueIsAdjusting()) {
                        viewport.setViewPosition(p);
                    }
                }
            }
        }

        public class myViewportChangeHandler
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                FastScrollPaneUI.this.syncScrollPaneWithViewport();
            }
        }
    }
}

