/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.connections;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.ext.DatabaseFileLockedException;
import com.db4o.ext.Db4oException;
import com.db4o.objectManager.v2.uiHelper.OptionPaneHelper;
import com.db4o.objectmanager.model.Db4oConnectionSpec;
import com.db4o.objectmanager.model.Db4oFileConnectionSpec;
import com.db4o.objectmanager.model.Db4oSocketConnectionSpec;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;

public class ConnectionHelper {
    public static ObjectContainer connect(Component frame, Db4oConnectionSpec connectionSpec) throws Exception {
        if (connectionSpec instanceof Db4oFileConnectionSpec) {
            return ConnectionHelper.connectToFile(frame, connectionSpec);
        }
        if (connectionSpec instanceof Db4oSocketConnectionSpec) {
            return ConnectionHelper.connectToServer((Db4oSocketConnectionSpec)connectionSpec);
        }
        throw new IllegalArgumentException("connectionSpec");
    }

    private static ObjectContainer connectToServer(Db4oSocketConnectionSpec spec) {
        return Db4o.openClient((Configuration)spec.newConfiguration(), (String)spec.getHost(), (int)spec.getPort(), (String)spec.getUser(), (String)spec.getPassword());
    }

    private static ObjectContainer connectToFile(Component frame, Db4oConnectionSpec connectionSpec) throws Exception {
        try {
            ConnectionHelper.assertFileExists(connectionSpec.getFullPath());
            return Db4o.openFile((Configuration)connectionSpec.newConfiguration(), (String)connectionSpec.getFullPath());
        }
        catch (DatabaseFileLockedException e) {
            OptionPaneHelper.showErrorMessage(frame, "Database file is locked. Another process must be using it.", "Database File Locked");
            throw e;
        }
        catch (Db4oException e) {
            if (e.getMessage().contains("Old database file format detected")) {
                OptionPaneHelper.showConfirmWarning(frame, "Old database file format detected. Would you like to upgrade?\nWARNING: This operation is irreversible and your application may not operate unless you update your db4o jar file to the latest version.", "Upgrade Database?");
            }
            throw e;
        }
        catch (Exception e) {
            OptionPaneHelper.showErrorMessage(frame, "Could not open database! " + e.getMessage(), "Error Opening Database");
            throw e;
        }
        return null;
    }

    private static void assertFileExists(String fullPath) throws FileNotFoundException {
        File f = new File(fullPath);
        if (!f.exists() || f.isDirectory()) {
            throw new FileNotFoundException("File not found: " + f.getAbsolutePath());
        }
    }
}

