/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.objectManager.v2.configuration;

import com.db4o.objectManager.v2.configuration.EncryptionProviderComboBoxModel;
import com.db4o.objectManager.v2.configuration.EncryptionProviderComboBoxRenderer;
import com.db4o.objectManager.v2.uiHelper.OptionPaneHelper;
import com.db4o.objectmanager.api.helpers.SerializerHelper;
import com.db4o.objectmanager.configuration.ConfigurationFacade;
import com.db4o.objectmanager.configuration.ConfigurationProvider;
import com.db4o.objectmanager.configuration.EncryptionProviderHandler;
import com.db4o.objectmanager.configuration.JarLoader;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.looks.Fonts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConfigurationPanel {
    private JComboBox _encryptionProvider;
    private ConfigurationProvider _configurationProvider;
    private JCheckBox _unicode;
    private JCheckBox _lockDatabase;
    private JCheckBox _callConstructors;
    private JCheckBox _saveConfigurationBox;
    private JTextField _encryptionPassword;
    private JButton _buildConfiguration;
    private ConfigurationFacade _configuration;
    private JDialog _container;
    private JPanel panel;

    public ConfigurationPanel() {
        this.initialize();
    }

    public ConfigurationPanel(ConfigurationFacade configuration) {
        this();
        this._configuration = configuration;
    }

    public ConfigurationPanel(JDialog container) {
        this();
        this._container = container;
    }

    public ConfigurationPanel(JDialog container, ConfigurationFacade currentConfiguration) {
        this(container);
        this.configuration(currentConfiguration);
    }

    private void initialize() {
        this._configurationProvider = new ConfigurationProvider();
    }

    public ConfigurationFacade configuration() {
        return this._configuration;
    }

    private void configuration(ConfigurationFacade configuration) {
        this._configuration = configuration;
    }

    public JPanel buildPanel() {
        FormLayout layout = new FormLayout("right:max(40dlu;pref), 3dlu, 120dlu, 7dlu,right:max(10dlu;pref), 3dlu, 80dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        JLabel descriptionLabel = new JLabel("Set Configuration");
        descriptionLabel.setFont(Fonts.WINDOWS_VISTA_96DPI_LARGE);
        descriptionLabel.setForeground(Color.white);
        builder.append((Component)descriptionLabel);
        builder.nextLine();
        builder.append((Component)this.getLabel("Unicode: "), (Component)this.unicode());
        builder.nextLine();
        builder.append((Component)this.getLabel("Lock Database file: "), (Component)this.lockDatabase());
        builder.nextLine();
        builder.append((Component)this.getLabel("Call Constructors: "), (Component)this.callConstructors());
        builder.nextLine();
        builder.append((Component)this.getLabel("Encryption Provider: "), (Component)this.encryptionProvider(), (Component)this.findEncryptionProvider());
        builder.nextLine();
        builder.append((Component)this.getLabel("Encryption Password: "), (Component)this.encryptionPassword());
        builder.nextLine();
        builder.append((Component)this.buildConfiguration(), (Component)this.cancel());
        builder.nextLine();
        builder.append("", (Component)this.saveConfigurationBox());
        this.panel = builder.getPanel();
        this.panel.setOpaque(false);
        this.applyConfiguration();
        return this.panel;
    }

    private JCheckBox unicode() {
        this._unicode = new JCheckBox();
        this._unicode.setOpaque(false);
        this._unicode.setSelected(true);
        return this._unicode;
    }

    private JCheckBox lockDatabase() {
        this._lockDatabase = new JCheckBox();
        this._lockDatabase.setOpaque(false);
        return this._lockDatabase;
    }

    private JCheckBox callConstructors() {
        this._callConstructors = new JCheckBox();
        this._callConstructors.setOpaque(false);
        this._callConstructors.setSelected(true);
        return this._callConstructors;
    }

    private JComboBox encryptionProvider() {
        this._encryptionProvider = new JComboBox();
        return this._encryptionProvider;
    }

    private JCheckBox saveConfigurationBox() {
        this._saveConfigurationBox = new JCheckBox();
        this._saveConfigurationBox.setText("Save Configuration");
        this._saveConfigurationBox.setOpaque(false);
        return this._saveConfigurationBox;
    }

    private JLabel getLabel(String text) {
        JLabel label = new JLabel(text);
        label.setForeground(Color.black);
        return label;
    }

    private JButton findEncryptionProvider() {
        JButton findEncryptionProvider = new JButton("...");
        findEncryptionProvider.setSize(new Dimension(25, 25));
        findEncryptionProvider.setMaximumSize(new Dimension(25, 25));
        findEncryptionProvider.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser jarFileChooser = ConfigurationPanel.this.jarFileChooser();
                int dialogResult = jarFileChooser.showDialog(ConfigurationPanel.this._container, "Ok");
                if (dialogResult == 0) {
                    File file = jarFileChooser.getSelectedFile();
                    String path = file.getPath();
                    ConfigurationPanel.this.loadEncryptionProvider(path);
                }
            }
        });
        return findEncryptionProvider;
    }

    private boolean loadEncryptionProvider(String path) {
        if (!new File(path).exists()) {
            return false;
        }
        JarLoader jarLoader = new JarLoader(path);
        EncryptionProviderComboBoxModel model = new EncryptionProviderComboBoxModel(jarLoader.getClasses(path));
        this._encryptionProvider.setModel(model);
        if (model.getDataSource().size() > 0) {
            this._encryptionProvider.setSelectedIndex(0);
        }
        this._encryptionProvider.setRenderer(new EncryptionProviderComboBoxRenderer());
        this._configurationProvider.encryptionProviderPath(path);
        return true;
    }

    private JButton cancel() {
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPanel.this._container.setVisible(false);
                ConfigurationPanel.this._container.dispose();
            }
        });
        return cancel;
    }

    private JFileChooser jarFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Select your Encryption Provider");
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Jar Files", "jar");
        fileChooser.setFileFilter(filter);
        fileChooser.setMultiSelectionEnabled(false);
        return fileChooser;
    }

    private JTextField encryptionPassword() {
        this._encryptionPassword = new JTextField();
        return this._encryptionPassword;
    }

    private JButton buildConfiguration() {
        this._buildConfiguration = new JButton("Ok");
        this._buildConfiguration.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigurationPanel.this._configurationProvider.unicodeEnabled(ConfigurationPanel.this._unicode.isSelected());
                ConfigurationPanel.this._configurationProvider.lockDatabase(ConfigurationPanel.this._lockDatabase.isSelected());
                ConfigurationPanel.this._configurationProvider.callConstructors(ConfigurationPanel.this._callConstructors.isSelected());
                ConfigurationPanel.this._configurationProvider.encryptionPassword(ConfigurationPanel.this._encryptionPassword.getText());
                try {
                    ConfigurationPanel.this._configurationProvider.encryptionProvider(EncryptionProviderHandler.getEncryptionProvider((Class)((Class)ConfigurationPanel.this._encryptionProvider.getSelectedItem()), (String)ConfigurationPanel.this._encryptionPassword.getText()));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, "Can't create an instance of the Encryption Provider");
                }
                ConfigurationPanel.this.configuration(ConfigurationPanel.this._configurationProvider.buildConfiguration());
                ConfigurationPanel.this.saveConfiguration(ConfigurationPanel.this.configuration());
                ConfigurationPanel.this._container.setVisible(false);
                ConfigurationPanel.this._container.dispose();
            }
        });
        return this._buildConfiguration;
    }

    private void saveConfiguration(ConfigurationFacade configuration) {
        if (!this._saveConfigurationBox.isSelected()) {
            return;
        }
        try {
            SerializerHelper.Serialize((Object)configuration, (String)ConfigurationFacade.CONFIGURATION_FILE_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void applyConfiguration() {
        if (this._configuration == null) {
            return;
        }
        this._unicode.setSelected(this._configuration.unicode());
        this._callConstructors.setSelected(this._configuration.callConstructors());
        this._lockDatabase.setSelected(this._configuration.lockDatabaseFile());
        this._encryptionPassword.setText(this._configuration.encryptionPassword());
        if (this._configuration.encriptionProviderPath() != null && this._configuration.encriptionProviderPath().trim().length() > 0 && !this.loadEncryptionProvider(this._configuration.encriptionProviderPath())) {
            OptionPaneHelper.showErrorMessage(this._container, "The file " + this._configuration.encriptionProviderPath() + "could not be opened, please load again your encryption provider.", "Encryption provider not found");
        }
    }
}

